/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.mysql.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.mysql.builder.ColumnSqlBuilder;
import org.dromara.autotable.strategy.mysql.builder.CreateTableSqlBuilder;
import org.dromara.autotable.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.strategy.mysql.data.MysqlCompareTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyTableSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static List<String> buildSql(MysqlCompareTableInfo mysqlCompareTableInfo) {
        String modifySql;
        String name = mysqlCompareTableInfo.getName();
        String collate = mysqlCompareTableInfo.getCollate();
        String engine = mysqlCompareTableInfo.getEngine();
        String characterSet = mysqlCompareTableInfo.getCharacterSet();
        String comment = mysqlCompareTableInfo.getComment();
        List<String> dropColumnList = mysqlCompareTableInfo.getDropColumnList();
        List<MysqlCompareTableInfo.MysqlModifyColumnMetadata> modifyMysqlColumnMetadataList = mysqlCompareTableInfo.getModifyMysqlColumnMetadataList();
        List<String> dropIndexList = mysqlCompareTableInfo.getDropIndexList();
        List<IndexMetadata> mysqlIndexMetadataList = mysqlCompareTableInfo.getIndexMetadataList();
        ArrayList<String> dropItems = new ArrayList<String>();
        ArrayList<String> modifyItems = new ArrayList<String>();
        boolean alterTableSeparateDrop = AutoTableGlobalConfig.instance().getAutoTableProperties().getMysql().isAlterTableSeparateDrop();
        String dropColumnSql = ModifyTableSqlBuilder.getDropColumnSql(dropColumnList);
        if (alterTableSeparateDrop) {
            dropItems.add(dropColumnSql);
        } else {
            modifyItems.add(dropColumnSql);
        }
        String columnsSql = ModifyTableSqlBuilder.getColumnsSql(modifyMysqlColumnMetadataList);
        modifyItems.add(columnsSql);
        if (mysqlCompareTableInfo.isDropPrimary()) {
            if (alterTableSeparateDrop) {
                dropItems.add("DROP PRIMARY KEY");
            } else {
                modifyItems.add("DROP PRIMARY KEY");
            }
        }
        if (!mysqlCompareTableInfo.getNewPrimaries().isEmpty()) {
            List<String> primaries = mysqlCompareTableInfo.getNewPrimaries().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            modifyItems.add("ADD " + primaryKeySql);
        }
        String dropIndexSql = ModifyTableSqlBuilder.getDropIndexSql(dropIndexList);
        if (alterTableSeparateDrop) {
            dropItems.add(dropIndexSql);
        } else {
            modifyItems.add(dropIndexSql);
        }
        String addIndexSql = ModifyTableSqlBuilder.getAddIndexSql(mysqlIndexMetadataList);
        modifyItems.add(addIndexSql);
        List<String> tableProperties = CreateTableSqlBuilder.getTableProperties(engine, characterSet, collate, comment);
        modifyItems.addAll(tableProperties);
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = IStrategy.wrapIdentifiers((String)name);
        String dropSql = dropItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        if (StringUtils.hasText((String)dropSql)) {
            String sql = "ALTER TABLE {tableName} {dropItems};".replace("{tableName}", tableName).replace("{dropItems}", dropSql);
            sqlList.add(sql);
        }
        if (StringUtils.hasText((String)(modifySql = modifyItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","))))) {
            String sql = "ALTER TABLE {tableName} {modifyItems};".replace("{tableName}", tableName).replace("{modifyItems}", modifySql);
            sqlList.add(sql);
        }
        return sqlList;
    }

    private static String getAddIndexSql(List<IndexMetadata> mysqlIndexMetadataList) {
        return mysqlIndexMetadataList.stream().map(indexParam -> {
            String indexSql = CreateTableSqlBuilder.getIndexSql(indexParam);
            return "ADD " + indexSql;
        }).collect(Collectors.joining(","));
    }

    private static String getDropIndexSql(List<String> dropIndexList) {
        return dropIndexList.stream().map(dropIndex -> "DROP INDEX {indexName}".replace("{indexName}", IStrategy.wrapIdentifiers((String)dropIndex))).collect(Collectors.joining(","));
    }

    private static String getDropColumnSql(List<String> dropColumnList) {
        return dropColumnList.stream().map(dropColumn -> "DROP COLUMN {columnName}".replace("{columnName}", IStrategy.wrapIdentifiers((String)dropColumn))).collect(Collectors.joining(","));
    }

    private static String getColumnsSql(List<MysqlCompareTableInfo.MysqlModifyColumnMetadata> modifyMysqlColumnMetadataList) {
        return modifyMysqlColumnMetadataList.stream().sorted(Comparator.comparingInt(modifyColumn -> modifyColumn.getMysqlColumnMetadata().getPosition())).map(modifyColumn -> {
            MysqlColumnMetadata columnMetadata = modifyColumn.getMysqlColumnMetadata();
            if (columnMetadata.isPrimary()) {
                columnMetadata.setNotNull(true);
            }
            String columnSql = ColumnSqlBuilder.buildSql(columnMetadata);
            if (modifyColumn.getType() == MysqlCompareTableInfo.ModifyType.MODIFY) {
                return "MODIFY COLUMN " + columnSql;
            }
            return "ADD COLUMN " + columnSql;
        }).collect(Collectors.joining(","));
    }
}

