/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.mysql.builder;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.annotation.ColumnType;
import org.dromara.autotable.annotation.mysql.MysqlColumnCharset;
import org.dromara.autotable.annotation.mysql.MysqlColumnUnsigned;
import org.dromara.autotable.annotation.mysql.MysqlColumnZerofill;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.mysql.ParamValidChecker;
import org.dromara.autotable.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.strategy.mysql.data.MysqlTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlColumnMetadataBuilder
extends ColumnMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlColumnMetadataBuilder.class);

    public MysqlColumnMetadataBuilder() {
        super("MySQL");
    }

    protected ColumnMetadata newColumnMetadata() {
        return new MysqlColumnMetadata();
    }

    protected void customBuild(ColumnMetadata columnMetadata, Class<?> clazz, Field field, int position) {
        MysqlColumnMetadata mysqlColumnMetadata = (MysqlColumnMetadata)columnMetadata;
        mysqlColumnMetadata.setPosition(position);
        MysqlColumnMetadataBuilder.extractCharsetAndCollate(field, mysqlColumnMetadata);
        this.extractColumnQualifier(field, mysqlColumnMetadata);
        ParamValidChecker.checkColumnParam(clazz, field, mysqlColumnMetadata);
    }

    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        String defaultValue = super.getDefaultValue(typeAndLength, columnDefault);
        if (StringUtils.hasText((String)defaultValue)) {
            if (MysqlTypeHelper.isBoolean(typeAndLength) && !"1".equals(defaultValue) && !"0".equals(defaultValue)) {
                defaultValue = Boolean.parseBoolean(defaultValue) ? "1" : "0";
            }
            if (MysqlTypeHelper.isCharString(typeAndLength) && !defaultValue.isEmpty() && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = "'" + defaultValue + "'";
            }
            if (MysqlTypeHelper.isDateTime(typeAndLength) && defaultValue.matches("(\\d+.?)+") && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = "'" + defaultValue + "'";
            }
        }
        return defaultValue;
    }

    protected DatabaseTypeAndLength getTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        DatabaseTypeAndLength typeAndLength = super.getTypeAndLength(databaseDialect, clazz, field);
        if (MysqlTypeHelper.isEnum(typeAndLength) && typeAndLength.getValues().isEmpty()) {
            Class<?> enumType = field.getType();
            if (enumType.isEnum()) {
                List values = AutoTableGlobalConfig.instance().getAutoTableMetadataAdapter().getColumnEnumValues(enumType);
                if (values.isEmpty()) {
                    values = Arrays.stream(enumType.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
                }
                typeAndLength.setValues(values);
            } else {
                String columnTypeName = ColumnType.class.getSimpleName();
                throw new RuntimeException(String.format("%s\u7684value\u4e3a\uff1a%s\u4e2d\u7684\u4e00\u79cd\u65f6\uff0c%s\u5fc5\u987b\u662f\u679a\u4e3e\u7c7b\u578b\u6216\u8005\u6307\u5b9a%s\u7684values", columnTypeName, String.join((CharSequence)", ", MysqlTypeHelper.ENUM_OR_SET_TYPE), clazz.getSimpleName() + "." + field.getName(), columnTypeName));
            }
        }
        return typeAndLength;
    }

    private static void extractCharsetAndCollate(Field field, MysqlColumnMetadata mysqlColumnMetadata) {
        String charset = null;
        String collate = null;
        MysqlColumnCharset mysqlColumnCharsetAnno = (MysqlColumnCharset)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, MysqlColumnCharset.class);
        if (mysqlColumnCharsetAnno != null) {
            charset = mysqlColumnCharsetAnno.value();
            if (StringUtils.hasText((String)mysqlColumnCharsetAnno.collate())) {
                collate = mysqlColumnCharsetAnno.collate();
            }
        } else {
            DatabaseTypeAndLength type = mysqlColumnMetadata.getType();
            if (MysqlTypeHelper.isCharString(type)) {
                PropertyConfig autoTableProperties = AutoTableGlobalConfig.instance().getAutoTableProperties();
                charset = autoTableProperties.getMysql().getColumnDefaultCharset();
                collate = autoTableProperties.getMysql().getColumnDefaultCollation();
            }
        }
        if (StringUtils.hasText((String)charset) && StringUtils.hasText((String)collate)) {
            mysqlColumnMetadata.setCharacterSet(charset);
            mysqlColumnMetadata.setCollate(collate);
        }
    }

    private void extractColumnQualifier(Field field, MysqlColumnMetadata mysqlColumnMetadata) {
        MysqlColumnZerofill mysqlColumnZerofill;
        MysqlColumnUnsigned mysqlColumnUnsigned = (MysqlColumnUnsigned)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, MysqlColumnUnsigned.class);
        if (mysqlColumnUnsigned != null) {
            mysqlColumnMetadata.setUnsigned(true);
        }
        if ((mysqlColumnZerofill = (MysqlColumnZerofill)AutoTableGlobalConfig.instance().getAutoTableAnnotationFinder().find(field, MysqlColumnZerofill.class)) != null) {
            mysqlColumnMetadata.setUnsigned(true);
            mysqlColumnMetadata.setZerofill(true);
        }
    }
}

