/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OracleDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl != null && jdbcUrl.startsWith("jdbc:oracle:") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "Oracle"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseBuilder.BuildResult build(String jdbcUrl, String targetUsername, String targetPassword, Consumer<Boolean> dbStatusCallback) {
        PropertyConfig.OracleConfig oracleConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getOracle();
        String execUsername = StringUtils.hasText((String)oracleConfig.getAdminUser()) ? oracleConfig.getAdminUser() : targetUsername;
        String execPassword = StringUtils.hasText((String)oracleConfig.getAdminPassword()) ? oracleConfig.getAdminPassword() : targetPassword;
        try (Connection conn = DriverManager.getConnection(jdbcUrl, execUsername, execPassword);){
            if (!this.hasCreateUserPrivilege(conn)) {
                log.warn("\u7528\u6237 [{}] \u65e0 CREATE USER \u6743\u9650\uff0c\u8df3\u8fc7 Oracle \u5efa\u5e93\u64cd\u4f5c", (Object)execUsername);
                DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUsername);
                return buildResult;
            }
            boolean userExists = this.userExists(conn, targetUsername);
            dbStatusCallback.accept(userExists);
            if (userExists) return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUsername);
            DatabaseBuilder.BuildResult buildResult = this.createUser(conn, targetUsername, targetPassword);
            return buildResult;
        }
        catch (SQLException e) {
            log.error("Oracle \u5efa\u5e93\u5931\u8d25\uff0c\u8fde\u63a5\u6216\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)false, (String)targetUsername);
    }

    private boolean hasCreateUserPrivilege(Connection conn) {
        boolean bl;
        block8: {
            PreparedStatement ps = conn.prepareStatement("SELECT COUNT(*) FROM USER_SYS_PRIVS WHERE PRIVILEGE = 'CREATE USER'");
            try {
                ResultSet rs = ps.executeQuery();
                boolean bl2 = bl = rs.next() && rs.getInt(1) > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.warn("\u68c0\u67e5 CREATE USER \u6743\u9650\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    private boolean userExists(Connection conn, String username) {
        boolean bl;
        block16: {
            PreparedStatement ps = conn.prepareStatement("SELECT USERNAME FROM DBA_USERS WHERE USERNAME = ?");
            try {
                ps.setString(1, username.toUpperCase());
                ResultSet rs = ps.executeQuery();
                bl = rs.next();
                if (ps == null) break block16;
            }
            catch (Throwable rs) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            rs.addSuppressed(throwable);
                        }
                    }
                    throw rs;
                }
                catch (SQLException e) {
                    boolean bl2;
                    block17: {
                        log.warn("\u65e0 DBA_USERS \u6743\u9650\uff0c\u5c1d\u8bd5\u4f7f\u7528 ALL_USERS \u68c0\u67e5\u7528\u6237\u662f\u5426\u5b58\u5728");
                        PreparedStatement ps2 = conn.prepareStatement("SELECT USERNAME FROM ALL_USERS WHERE USERNAME = ?");
                        try {
                            ps2.setString(1, username.toUpperCase());
                            ResultSet rs2 = ps2.executeQuery();
                            bl2 = rs2.next();
                            if (ps2 == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ps2 != null) {
                                    try {
                                        ps2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException ex) {
                                log.error("ALL_USERS \u67e5\u8be2\u4e5f\u5931\u8d25\uff0c\u65e0\u6cd5\u5224\u65ad\u7528\u6237\u662f\u5426\u5b58\u5728", (Throwable)ex);
                                return false;
                            }
                        }
                        ps2.close();
                    }
                    return bl2;
                }
            }
            ps.close();
        }
        return bl;
    }

    private DatabaseBuilder.BuildResult createUser(Connection conn, String username, String password) throws SQLException {
        DatabaseBuilder.BuildResult buildResult;
        block8: {
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE USER " + username + " IDENTIFIED BY " + password);
                stmt.executeUpdate("GRANT CONNECT, RESOURCE TO " + username);
                log.info("Oracle \u7528\u6237\u521b\u5efa\u6210\u529f\uff1a{}", (Object)username);
                buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)username);
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return DatabaseBuilder.BuildResult.of((boolean)false, (String)username);
                }
            }
            stmt.close();
        }
        return buildResult;
    }
}

