/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.util.HashMap;
import lombok.Generated;
import org.dromara.autotable.strategy.oracle.OracleHelper;

public class TabVersion {
    private String banner;
    private String version;
    private int mainVersion;

    public static TabVersion search() {
        String sql = "select banner from v$version";
        return OracleHelper.DB.queryList(sql, new HashMap<String, Object>(), TabVersion.class).stream().filter(it -> it.getBanner().toLowerCase().contains("release ")).findFirst().map(it -> {
            String banner = it.getBanner().toLowerCase();
            String version = banner.substring(banner.indexOf("release ") + 8);
            version = version.substring(0, version.indexOf(" "));
            String mainVersion = version.substring(0, version.indexOf("."));
            it.setBanner(banner);
            it.setVersion(version);
            it.setMainVersion(Integer.parseInt(mainVersion));
            return it;
        }).orElseGet(TabVersion::new);
    }

    @Generated
    public TabVersion() {
    }

    @Generated
    public String getBanner() {
        return this.banner;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public int getMainVersion() {
        return this.mainVersion;
    }

    @Generated
    public void setBanner(String banner) {
        this.banner = banner;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setMainVersion(int mainVersion) {
        this.mainVersion = mainVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabVersion)) {
            return false;
        }
        TabVersion other = (TabVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMainVersion() != other.getMainVersion()) {
            return false;
        }
        String this$banner = this.getBanner();
        String other$banner = other.getBanner();
        if (this$banner == null ? other$banner != null : !this$banner.equals(other$banner)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMainVersion();
        String $banner = this.getBanner();
        result = result * 59 + ($banner == null ? 43 : $banner.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TabVersion(banner=" + this.getBanner() + ", version=" + this.getVersion() + ", mainVersion=" + this.getMainVersion() + ")";
    }
}

