/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.autotable.annotation.enums.IndexSortTypeEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.builder.DefaultTableMetadataBuilder;
import org.dromara.autotable.core.builder.IndexMetadataBuilder;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.converter.DatabaseTypeDefine;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.oracle.OracleCompareTableInfo;
import org.dromara.autotable.strategy.oracle.OracleHelper;
import org.dromara.autotable.strategy.oracle.TabColumn;
import org.dromara.autotable.strategy.oracle.TabComment;
import org.dromara.autotable.strategy.oracle.TabIndex;
import org.dromara.autotable.strategy.oracle.TabSequence;
import org.dromara.autotable.strategy.oracle.TabVersion;

public class OracleStrategy
implements IStrategy<DefaultTableMetadata, OracleCompareTableInfo> {
    private static final DefaultTableMetadataBuilder tableMetadataBuilder = new DefaultTableMetadataBuilder(new ColumnMetadataBuilder("Oracle"), new IndexMetadataBuilder());

    public String databaseDialect() {
        return "Oracle";
    }

    public String wrapSql(String rawSql) {
        return rawSql;
    }

    public int indexNameMaxLength() {
        return 30;
    }

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        final DatabaseTypeDefine strType = DatabaseTypeDefine.of((String)"VARCHAR2", (int)255);
        final DatabaseTypeDefine boolType = DatabaseTypeDefine.of((String)"NUMBER", (Integer)1, (Integer)0);
        final DatabaseTypeDefine shortType = DatabaseTypeDefine.of((String)"NUMBER", (Integer)5, (Integer)0);
        final DatabaseTypeDefine intType = DatabaseTypeDefine.of((String)"NUMBER", (Integer)10, (Integer)0);
        final DatabaseTypeDefine longType = DatabaseTypeDefine.of((String)"NUMBER", (Integer)19, (Integer)0);
        final DatabaseTypeDefine floatType = DatabaseTypeDefine.of((String)"BINARY_FLOAT");
        final DatabaseTypeDefine doubleType = DatabaseTypeDefine.of((String)"BINARY_DOUBLE");
        final DatabaseTypeDefine bigDecimalType = DatabaseTypeDefine.of((String)"NUMBER", (Integer)38, (Integer)18);
        final DatabaseTypeDefine timestampType = DatabaseTypeDefine.of((String)"TIMESTAMP", (int)6);
        final DatabaseTypeDefine dateType = DatabaseTypeDefine.of((String)"DATE");
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                super(initialCapacity);
                this.put(String.class, strType);
                this.put(Character.class, strType);
                this.put(Character.TYPE, strType);
                this.put(Boolean.class, boolType);
                this.put(Boolean.TYPE, boolType);
                this.put(Short.class, shortType);
                this.put(Short.TYPE, shortType);
                this.put(Integer.class, intType);
                this.put(Integer.TYPE, intType);
                this.put(BigInteger.class, longType);
                this.put(Long.class, longType);
                this.put(Long.TYPE, longType);
                this.put(Float.class, floatType);
                this.put(Float.TYPE, floatType);
                this.put(Double.class, doubleType);
                this.put(Double.TYPE, doubleType);
                this.put(BigDecimal.class, bigDecimalType);
                this.put(java.util.Date.class, timestampType);
                this.put(Time.class, timestampType);
                this.put(Date.class, dateType);
                this.put(Timestamp.class, timestampType);
                this.put(LocalTime.class, timestampType);
                this.put(LocalDate.class, dateType);
                this.put(LocalDateTime.class, timestampType);
            }
        };
    }

    public String dropTable(String schema, String tableName) {
        return String.format("DECLARE     table_count INTEGER;     auto_seq_count   INTEGER; BEGIN     SELECT COUNT(*) INTO table_count FROM user_tables WHERE upper(table_name) = upper('%s');     IF table_count > 0 THEN         EXECUTE IMMEDIATE 'DROP TABLE %s';     END IF;     SELECT COUNT(*) INTO auto_seq_count FROM user_sequences WHERE upper(sequence_name) = upper('auto_seq_%s');     IF auto_seq_count > 0 THEN         EXECUTE IMMEDIATE 'DROP SEQUENCE auto_seq_%s';     END IF;END;", tableName, tableName, tableName, tableName).replaceAll("\\s+", " ");
    }

    @NonNull
    public DefaultTableMetadata analyseClass(Class<?> beanClass) {
        TabVersion search;
        DefaultTableMetadata tableMetadata = tableMetadataBuilder.build(beanClass);
        ColumnMetadata primaryKey = tableMetadata.getColumnMetadataList().stream().filter(ColumnMetadata::isPrimary).findFirst().orElse(null);
        if (primaryKey != null && primaryKey.isPrimary() && primaryKey.isAutoIncrement() && (search = TabVersion.search()).getMainVersion() < 12) {
            primaryKey.setAutoIncrement(false);
            log.warn("\u5f53\u524dOracle\u7248\u672c\u3010{}\u3011Oracle12\u4ee5\u4e0b\u7248\u672c\u4e0d\u652f\u6301\u4e3b\u952e\u81ea\u589e\u9ed8\u8ba4\u503c, \u5c06\u5ffd\u7565\u3010{}\u3011\u4e3b\u952e\u7684\u3010autoIncrement = true\u3011\u5c5e\u6027", (Object)search.getVersion(), (Object)beanClass.getName());
        }
        return tableMetadata;
    }

    public List<String> createTable(DefaultTableMetadata tableMetadata) {
        ArrayList<String> result = new ArrayList<String>();
        String tableName = tableMetadata.getTableName();
        String tableComment = Optional.ofNullable(tableMetadata.getComment()).orElse("");
        List columnMetadataList = tableMetadata.getColumnMetadataList();
        List indexMetadataList = tableMetadata.getIndexMetadataList();
        ColumnMetadata primaryKey = columnMetadataList.stream().filter(ColumnMetadata::isPrimary).findFirst().orElse(null);
        if (primaryKey != null && primaryKey.isAutoIncrement()) {
            result.add(String.format("CREATE SEQUENCE auto_seq_%s", tableName));
        }
        List columnSqlList = columnMetadataList.stream().map(it -> OracleHelper.SQL.toColumnSql(tableName, it)).collect(Collectors.toList());
        result.add(String.format("CREATE TABLE %s (%s)", tableName, String.join((CharSequence)", ", columnSqlList)));
        if (primaryKey != null) {
            result.add(String.format("ALTER TABLE %s ADD CONSTRAINT auto_pk_%s PRIMARY KEY(%s)", tableName, tableName, primaryKey.getName()));
        }
        result.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, tableComment));
        for (ColumnMetadata columnMetadata : columnMetadataList) {
            String columnName = columnMetadata.getName();
            String columnComment = Optional.ofNullable(columnMetadata.getComment()).orElse("");
            result.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnName, columnComment));
        }
        for (IndexMetadata indexMetadata : indexMetadataList) {
            result.add(OracleHelper.SQL.toIndexSql(tableName, indexMetadata));
        }
        return result;
    }

    @NonNull
    public OracleCompareTableInfo compareTable(DefaultTableMetadata tableMetadata) {
        OracleCompareTableInfo compareTableInfo = new OracleCompareTableInfo(tableMetadata.getTableName(), tableMetadata.getSchema());
        String tableName = tableMetadata.getTableName();
        String newTableComment = Optional.ofNullable(tableMetadata.getComment()).orElse("");
        ColumnMetadata newPrimaryKey = tableMetadata.getColumnMetadataList().stream().filter(ColumnMetadata::isPrimary).findAny().orElse(null);
        List newColumnList = tableMetadata.getColumnMetadataList();
        Set newColumnNameSet = newColumnList.stream().map(ColumnMetadata::getName).map(String::toLowerCase).collect(Collectors.toSet());
        List newIndexList = tableMetadata.getIndexMetadataList();
        Set newIndexNameSet = newIndexList.stream().map(IndexMetadata::getName).map(String::toLowerCase).collect(Collectors.toSet());
        String oldTableComment = Optional.of(TabComment.search(tableName)).map(TabComment::getComments).orElse("");
        List oldColumnList = TabColumn.search(tableName).stream().peek(it -> {
            String dataDefault = it.getData_default();
            String seqName = ".\"auto_seq_" + tableName + "\".\"nextval\"";
            if (StringUtils.hasText((String)dataDefault) && dataDefault.toLowerCase().endsWith(seqName.toLowerCase())) {
                it.setData_default("auto_seq_" + tableName + ".nextval".toLowerCase());
            }
        }).collect(Collectors.toList());
        Map oldColumnMap = oldColumnList.stream().collect(Collectors.toMap(it -> it.getColumn_name().toLowerCase(), Function.identity()));
        TabColumn oldPrimaryKey = oldColumnList.stream().filter(it -> "P".equals(it.getConstraint_type())).findAny().orElse(null);
        Map<String, List<TabIndex>> oldIndexMap = TabIndex.search(tableName).stream().peek(it -> {
            String columnExpression = it.getColumn_expression();
            if (columnExpression != null) {
                it.setColumn_name(columnExpression.substring(1, columnExpression.length() - 1));
            }
        }).collect(Collectors.groupingBy(it -> it.getIndex_name().toLowerCase()));
        compareTableInfo.setNeedSequence(newPrimaryKey != null && newPrimaryKey.isAutoIncrement());
        TabSequence oldSequence = TabSequence.search(tableName);
        compareTableInfo.setHasSequence(oldSequence != null);
        if (!newTableComment.equals(oldTableComment)) {
            compareTableInfo.setTableComment(newTableComment);
        }
        if (!(oldPrimaryKey == null || newPrimaryKey != null && newPrimaryKey.getName().equalsIgnoreCase(oldPrimaryKey.getColumn_name()))) {
            compareTableInfo.setDeletePrimaryKey(oldPrimaryKey);
        }
        if (!(newPrimaryKey == null || oldPrimaryKey != null && newPrimaryKey.getName().equalsIgnoreCase(oldPrimaryKey.getColumn_name()))) {
            compareTableInfo.setCreatePrimaryKey(newPrimaryKey);
        }
        List<ColumnMetadata> createColumnList = newColumnList.stream().filter(it -> !oldColumnMap.containsKey(it.getName().toLowerCase())).collect(Collectors.toList());
        compareTableInfo.setCreateColumnList(createColumnList);
        List<String> deleteColumnList = oldColumnList.stream().map(TabColumn::getColumn_name).map(String::toLowerCase).filter(columnName -> !newColumnNameSet.contains(columnName)).collect(Collectors.toList());
        compareTableInfo.setDeleteColumnList(deleteColumnList);
        HashSet updateColumnSet = new HashSet();
        List<String> updateColumnList = newColumnList.stream().filter(it -> oldColumnMap.containsKey(it.getName().toLowerCase())).map(newColumn -> {
            boolean oldNullAble;
            boolean newNullAble;
            String oldDefaultValue;
            String newDefaultValue;
            String oldType;
            TabColumn oldColumn = (TabColumn)oldColumnMap.get(newColumn.getName().toLowerCase());
            String newColumnSql = newColumn.getName();
            boolean change = false;
            String newType = newColumn.getType().getDefaultFullType();
            if (!newType.equalsIgnoreCase(oldType = oldColumn.getFullType())) {
                change = true;
                updateColumnSet.add(newColumn.getName().toLowerCase());
                newColumnSql = newColumnSql + " " + newType;
            }
            if (!(newDefaultValue = OracleHelper.SQL.formatDefaultValue(tableName, newColumn)).equalsIgnoreCase(oldDefaultValue = String.valueOf(oldColumn.getData_default()).trim())) {
                change = true;
                updateColumnSet.add(newColumn.getName().toLowerCase());
                newColumnSql = newColumnSql + " DEFAULT " + newDefaultValue;
            }
            if ((newNullAble = !newColumn.isNotNull()) != (oldNullAble = "Y".equals(oldColumn.getNullable()))) {
                change = true;
                updateColumnSet.add(newColumn.getName().toLowerCase());
                newColumnSql = newNullAble ? newColumnSql + " NULL" : newColumnSql + " NOT NULL";
            }
            return change ? newColumnSql : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        compareTableInfo.setUpdateColumnList(updateColumnList);
        List<ColumnMetadata> updateColumnCommentList = newColumnList.stream().filter(it -> oldColumnMap.containsKey(it.getName().toLowerCase())).filter(newColumn -> {
            String oldComment;
            TabColumn oldColumn = (TabColumn)oldColumnMap.get(newColumn.getName().toLowerCase());
            String newComment = Optional.ofNullable(newColumn.getComment()).orElse("");
            return !newComment.equals(oldComment = Optional.ofNullable(oldColumn.getComments()).orElse(""));
        }).collect(Collectors.toList());
        compareTableInfo.setUpdateColumnCommentList(updateColumnCommentList);
        HashSet<String> deleteIndexList = new HashSet<String>();
        ArrayList<IndexMetadata> createIndexList = new ArrayList<IndexMetadata>();
        for (IndexMetadata newIndex : newIndexList) {
            String indexName = newIndex.getName().toLowerCase();
            List newIndexColumns = newIndex.getColumns();
            List newIndexColumnNames = newIndex.getColumns().stream().map(IndexMetadata.IndexColumnParam::getColumn).map(String::toLowerCase).collect(Collectors.toList());
            if (updateColumnSet.stream().anyMatch(newIndexColumnNames::contains)) {
                createIndexList.add(newIndex);
                if (!oldIndexMap.containsKey(indexName)) continue;
                deleteIndexList.add(indexName);
                continue;
            }
            if (!oldIndexMap.containsKey(indexName)) {
                createIndexList.add(newIndex);
                continue;
            }
            List<TabIndex> oldIndexColumns = oldIndexMap.get(newIndex.getName().toLowerCase());
            if (newIndexColumns.size() != oldIndexColumns.size()) {
                createIndexList.add(newIndex);
                deleteIndexList.add(indexName);
                continue;
            }
            for (int i = 0; i < newIndexColumns.size(); ++i) {
                String oldSort;
                IndexMetadata.IndexColumnParam newIndexColumn = (IndexMetadata.IndexColumnParam)newIndexColumns.get(i);
                TabIndex oldIndexColumn = oldIndexColumns.get(i);
                if (!newIndexColumn.getColumn().equalsIgnoreCase(oldIndexColumn.getColumn_name())) {
                    createIndexList.add(newIndex);
                    deleteIndexList.add(indexName);
                    continue;
                }
                String newSort = Optional.ofNullable(newIndexColumn.getSort()).orElse(IndexSortTypeEnum.ASC).name().toLowerCase();
                if (newSort.equals(oldSort = Optional.ofNullable(oldIndexColumn.getDescend()).orElse("ASC").toLowerCase())) continue;
                createIndexList.add(newIndex);
                deleteIndexList.add(indexName);
            }
        }
        oldIndexMap.keySet().stream().filter(oldIndexName -> !newIndexNameSet.contains(oldIndexName.toLowerCase())).forEach(deleteIndexList::add);
        compareTableInfo.setDeleteIndexList(deleteIndexList);
        compareTableInfo.setCreateIndexList(createIndexList);
        return compareTableInfo;
    }

    public List<String> modifyTable(OracleCompareTableInfo compareTableInfo) {
        ColumnMetadata createPrimaryKey;
        TabColumn deletePrimaryKey;
        ArrayList<String> result = new ArrayList<String>();
        PropertyConfig properties = AutoTableGlobalConfig.instance().getAutoTableProperties();
        String tableName = compareTableInfo.getName();
        if (properties.getAutoDropIndex().booleanValue()) {
            Iterator<Object> indexPrefix = properties.getIndexPrefix().toLowerCase();
            Boolean dropCustomIndex = properties.getAutoDropCustomIndex();
            for (String indexName : compareTableInfo.getDeleteIndexList()) {
                boolean isAutoIndex = indexName.startsWith((String)((Object)indexPrefix));
                if (!isAutoIndex && !dropCustomIndex.booleanValue()) continue;
                result.add(String.format("DROP INDEX %s", indexName));
            }
        }
        if (compareTableInfo.isNeedSequence() && !compareTableInfo.isHasSequence()) {
            result.add(String.format("CREATE SEQUENCE auto_seq_%s", tableName));
        }
        if (properties.getAutoDropColumn().booleanValue()) {
            for (String column : compareTableInfo.getDeleteColumnList()) {
                result.add(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, column));
            }
        }
        for (ColumnMetadata columnMetadata : compareTableInfo.getCreateColumnList()) {
            String columnSql = OracleHelper.SQL.toColumnSql(tableName, columnMetadata);
            result.add(String.format("ALTER TABLE %s ADD (%s)", tableName, columnSql));
        }
        for (String columnSql : compareTableInfo.getUpdateColumnList()) {
            result.add(String.format("ALTER TABLE %s MODIFY (%s)", tableName, columnSql));
        }
        if (!compareTableInfo.isNeedSequence() && compareTableInfo.isHasSequence()) {
            result.add(String.format("DROP SEQUENCE auto_seq_%s", tableName));
        }
        if ((deletePrimaryKey = compareTableInfo.getDeletePrimaryKey()) != null) {
            result.add(String.format("ALTER TABLE %s DROP CONSTRAINT %s", tableName, deletePrimaryKey.getConstraint_name()));
        }
        if ((createPrimaryKey = compareTableInfo.getCreatePrimaryKey()) != null) {
            result.add(String.format("ALTER TABLE %s ADD CONSTRAINT auto_pk_%s PRIMARY KEY(%s)", tableName, tableName, createPrimaryKey.getName()));
        }
        for (IndexMetadata indexMetadata : compareTableInfo.getCreateIndexList()) {
            String indexSql = OracleHelper.SQL.toIndexSql(tableName, indexMetadata);
            result.add(indexSql);
        }
        if (compareTableInfo.getTableComment() != null) {
            result.add(String.format("COMMENT ON TABLE %s IS '%s'", tableName, compareTableInfo.getTableComment()));
        }
        for (ColumnMetadata columnMetadata : compareTableInfo.getUpdateColumnCommentList()) {
            result.add(String.format("COMMENT ON COLUMN %s.%s IS '%s'", tableName, columnMetadata.getName(), columnMetadata.getComment()));
        }
        return result;
    }
}

