/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.dromara.autotable.strategy.oracle.OracleHelper;

public class TabIndex {
    private String table_name;
    private String table_type;
    private String index_name;
    private String index_type;
    private String uniqueness;
    private String column_name;
    private Integer column_position;
    private String descend;
    private String column_expression;

    public static List<TabIndex> search(String tableName) {
        Map<String, Object> params = Collections.singletonMap("tableName", tableName);
        String sql = "SELECT idx.table_name      , idx.table_type      , idx.index_name      , idx.index_type      , idx.uniqueness      , col.column_name      , col.column_position      , col.descend      , exp.column_expression FROM user_indexes idx          LEFT JOIN user_ind_columns col ON idx.table_name = col.table_name AND idx.index_name = col.index_name          LEFT JOIN user_ind_expressions exp ON col.table_name = exp.table_name AND col.index_name = exp.index_name AND col.column_position = exp.column_position          LEFT JOIN user_constraints uc ON idx.index_name = uc.index_name WHERE idx.table_type = 'TABLE'   AND idx.generated = 'N'   AND uc.INDEX_NAME IS NULL   AND upper(idx.table_name) = upper(':tableName') ORDER BY idx.index_name, col.column_position";
        return OracleHelper.DB.queryList(sql.replaceAll("\\s+", " "), params, TabIndex.class);
    }

    @Generated
    public TabIndex() {
    }

    @Generated
    public String getTable_name() {
        return this.table_name;
    }

    @Generated
    public String getTable_type() {
        return this.table_type;
    }

    @Generated
    public String getIndex_name() {
        return this.index_name;
    }

    @Generated
    public String getIndex_type() {
        return this.index_type;
    }

    @Generated
    public String getUniqueness() {
        return this.uniqueness;
    }

    @Generated
    public String getColumn_name() {
        return this.column_name;
    }

    @Generated
    public Integer getColumn_position() {
        return this.column_position;
    }

    @Generated
    public String getDescend() {
        return this.descend;
    }

    @Generated
    public String getColumn_expression() {
        return this.column_expression;
    }

    @Generated
    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    @Generated
    public void setTable_type(String table_type) {
        this.table_type = table_type;
    }

    @Generated
    public void setIndex_name(String index_name) {
        this.index_name = index_name;
    }

    @Generated
    public void setIndex_type(String index_type) {
        this.index_type = index_type;
    }

    @Generated
    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }

    @Generated
    public void setColumn_name(String column_name) {
        this.column_name = column_name;
    }

    @Generated
    public void setColumn_position(Integer column_position) {
        this.column_position = column_position;
    }

    @Generated
    public void setDescend(String descend) {
        this.descend = descend;
    }

    @Generated
    public void setColumn_expression(String column_expression) {
        this.column_expression = column_expression;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabIndex)) {
            return false;
        }
        TabIndex other = (TabIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$column_position = this.getColumn_position();
        Integer other$column_position = other.getColumn_position();
        if (this$column_position == null ? other$column_position != null : !((Object)this$column_position).equals(other$column_position)) {
            return false;
        }
        String this$table_name = this.getTable_name();
        String other$table_name = other.getTable_name();
        if (this$table_name == null ? other$table_name != null : !this$table_name.equals(other$table_name)) {
            return false;
        }
        String this$table_type = this.getTable_type();
        String other$table_type = other.getTable_type();
        if (this$table_type == null ? other$table_type != null : !this$table_type.equals(other$table_type)) {
            return false;
        }
        String this$index_name = this.getIndex_name();
        String other$index_name = other.getIndex_name();
        if (this$index_name == null ? other$index_name != null : !this$index_name.equals(other$index_name)) {
            return false;
        }
        String this$index_type = this.getIndex_type();
        String other$index_type = other.getIndex_type();
        if (this$index_type == null ? other$index_type != null : !this$index_type.equals(other$index_type)) {
            return false;
        }
        String this$uniqueness = this.getUniqueness();
        String other$uniqueness = other.getUniqueness();
        if (this$uniqueness == null ? other$uniqueness != null : !this$uniqueness.equals(other$uniqueness)) {
            return false;
        }
        String this$column_name = this.getColumn_name();
        String other$column_name = other.getColumn_name();
        if (this$column_name == null ? other$column_name != null : !this$column_name.equals(other$column_name)) {
            return false;
        }
        String this$descend = this.getDescend();
        String other$descend = other.getDescend();
        if (this$descend == null ? other$descend != null : !this$descend.equals(other$descend)) {
            return false;
        }
        String this$column_expression = this.getColumn_expression();
        String other$column_expression = other.getColumn_expression();
        return !(this$column_expression == null ? other$column_expression != null : !this$column_expression.equals(other$column_expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabIndex;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $column_position = this.getColumn_position();
        result = result * 59 + ($column_position == null ? 43 : ((Object)$column_position).hashCode());
        String $table_name = this.getTable_name();
        result = result * 59 + ($table_name == null ? 43 : $table_name.hashCode());
        String $table_type = this.getTable_type();
        result = result * 59 + ($table_type == null ? 43 : $table_type.hashCode());
        String $index_name = this.getIndex_name();
        result = result * 59 + ($index_name == null ? 43 : $index_name.hashCode());
        String $index_type = this.getIndex_type();
        result = result * 59 + ($index_type == null ? 43 : $index_type.hashCode());
        String $uniqueness = this.getUniqueness();
        result = result * 59 + ($uniqueness == null ? 43 : $uniqueness.hashCode());
        String $column_name = this.getColumn_name();
        result = result * 59 + ($column_name == null ? 43 : $column_name.hashCode());
        String $descend = this.getDescend();
        result = result * 59 + ($descend == null ? 43 : $descend.hashCode());
        String $column_expression = this.getColumn_expression();
        result = result * 59 + ($column_expression == null ? 43 : $column_expression.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TabIndex(table_name=" + this.getTable_name() + ", table_type=" + this.getTable_type() + ", index_name=" + this.getIndex_name() + ", index_type=" + this.getIndex_type() + ", uniqueness=" + this.getUniqueness() + ", column_name=" + this.getColumn_name() + ", column_position=" + this.getColumn_position() + ", descend=" + this.getDescend() + ", column_expression=" + this.getColumn_expression() + ")";
    }
}

