/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.DBHelper;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;

public class OracleHelper {
    private static final QueryRunner queryRunner = new QueryRunner();
    private static final BasicRowProcessor convert = new BasicRowProcessor(new BeanProcessor(){

        protected Object processColumn(ResultSet resultSet, int index, Class<?> propType) throws SQLException {
            String value = resultSet.getString(index);
            if (StringUtils.hasText((String)value) && Integer.class.equals(propType)) {
                return Integer.parseInt(value);
            }
            return value;
        }
    });

    public static class SQL {
        public static String toColumnSql(String tableName, ColumnMetadata columnMetadata) {
            return StringConnectHelper.newInstance((String)"{column_name} {column_type}{default_value}{null}").replace("{column_name}", columnMetadata.getName()).replace("{column_type}", columnMetadata.getType().getDefaultFullType()).replace("{default_value}", () -> {
                String defaultValue = SQL.formatDefaultValue(tableName, columnMetadata);
                if (StringUtils.hasText((String)defaultValue)) {
                    return " DEFAULT " + defaultValue;
                }
                return "";
            }).replace("{null}", columnMetadata.isNotNull() ? " NOT NULL" : "").toString().trim();
        }

        public static String toIndexSql(String tableName, IndexMetadata indexMetadata) {
            IndexTypeEnum type = indexMetadata.getType();
            String indexName = indexMetadata.getName();
            List columnDefines = indexMetadata.getColumns().stream().map(it -> {
                if (it.getSort() == null) {
                    return it.getColumn();
                }
                return it.getColumn() + " " + it.getSort().name();
            }).collect(Collectors.toList());
            return StringConnectHelper.newInstance((String)"CREATE {unique}INDEX {index_name} ON {table_name}({columns})").replace("{unique}", type == IndexTypeEnum.UNIQUE ? "UNIQUE " : "").replace("{index_name}", indexName).replace("{table_name}", tableName).replace("{columns}", String.join((CharSequence)", ", columnDefines)).toString();
        }

        public static String formatDefaultValue(String tableName, ColumnMetadata columnMetadata) {
            if (columnMetadata.isPrimary() && columnMetadata.isAutoIncrement()) {
                return "auto_seq_" + tableName + ".nextval";
            }
            DefaultValueEnum type = columnMetadata.getDefaultValueType();
            String value = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.NULL.equals((Object)type)) {
                return "null";
            }
            if (DefaultValueEnum.EMPTY_STRING.equals((Object)type)) {
                return "''";
            }
            if (StringUtils.noText((String)value)) {
                return "null";
            }
            String typeDefine = columnMetadata.getType().getDefaultFullType().toLowerCase();
            if (typeDefine.contains("number") || typeDefine.contains("double") || typeDefine.contains("float")) {
                return value;
            }
            if ("SYSDATE".equalsIgnoreCase(value)) {
                return "SYSDATE";
            }
            if ("USER".equalsIgnoreCase(value)) {
                return "USER";
            }
            if (value.startsWith("'")) {
                return value;
            }
            if (typeDefine.contains("char") || typeDefine.contains("clob")) {
                return "'" + value + "'";
            }
            return value;
        }
    }

    public static class DB {
        public static <T> List<T> queryList(String sql, Map<String, Object> params, Class<T> resultClass) {
            return (List)DataSourceManager.useConnection(connection -> {
                String finalSql = DBHelper.setParameters((String)sql, (Map)params);
                try {
                    return (List)queryRunner.query(connection, finalSql, (ResultSetHandler)new BeanListHandler(resultClass, (RowProcessor)convert));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public static <T> T queryOne(String sql, Map<String, Object> params, Class<T> resultClass) {
            List<T> list = DB.queryList(sql, params, resultClass);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }
}

