/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.dromara.autotable.strategy.oracle.OracleHelper;

public class TabColumn {
    private String table_name;
    private String column_name;
    private String data_type;
    private Integer data_length;
    private Integer data_precision;
    private Integer data_scale;
    private String nullable;
    private Integer column_id;
    private String data_default;
    private String comments;
    private String constraint_name;
    private String constraint_type;

    public String getFullType() {
        String fullType = this.data_type;
        if (fullType.toLowerCase().contains("clob")) {
            return fullType;
        }
        if (fullType.contains("(") && fullType.contains(")")) {
            return fullType;
        }
        if (this.data_length == null && this.data_precision == null && this.data_scale == null) {
            return fullType;
        }
        if (this.data_precision == null && this.data_scale == null) {
            return fullType + "(" + this.data_length + ")";
        }
        if (this.data_precision != null) {
            fullType = fullType + "(" + this.data_precision;
            if (this.data_scale != null) {
                fullType = fullType + "," + this.data_scale;
            }
            fullType = fullType + ")";
        }
        return fullType;
    }

    public static List<TabColumn> search(String tableName) {
        Map<String, Object> params = Collections.singletonMap("tableName", tableName);
        String sql = "SELECT tc.table_name      , tc.column_name      , tc.data_type      , tc.data_length      , tc.data_precision      , tc.data_scale      , tc.nullable      , tc.column_id      , tc.data_default      , cc.comments      , pk.constraint_name      , pk.constraint_type       FROM user_tab_columns tc                LEFT JOIN user_col_comments cc ON tc.table_name = cc.table_name AND tc.column_name = cc.column_name                LEFT JOIN (SELECT cons_col.table_name                                , cons_col.column_name                                , cons_col.constraint_name                                , cons.constraint_type                           FROM user_cons_columns cons_col                                    LEFT JOIN user_constraints cons ON cons_col.constraint_name = cons.constraint_name                           WHERE cons.constraint_type = 'P') pk                          ON tc.table_name = pk.table_name AND tc.column_name = pk.column_name       WHERE UPPER(tc.table_name) = UPPER(':tableName')       ORDER BY tc.column_id";
        return OracleHelper.DB.queryList(sql.replaceAll("\\s+", " "), params, TabColumn.class);
    }

    @Generated
    public TabColumn() {
    }

    @Generated
    public String getTable_name() {
        return this.table_name;
    }

    @Generated
    public String getColumn_name() {
        return this.column_name;
    }

    @Generated
    public String getData_type() {
        return this.data_type;
    }

    @Generated
    public Integer getData_length() {
        return this.data_length;
    }

    @Generated
    public Integer getData_precision() {
        return this.data_precision;
    }

    @Generated
    public Integer getData_scale() {
        return this.data_scale;
    }

    @Generated
    public String getNullable() {
        return this.nullable;
    }

    @Generated
    public Integer getColumn_id() {
        return this.column_id;
    }

    @Generated
    public String getData_default() {
        return this.data_default;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public String getConstraint_name() {
        return this.constraint_name;
    }

    @Generated
    public String getConstraint_type() {
        return this.constraint_type;
    }

    @Generated
    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    @Generated
    public void setColumn_name(String column_name) {
        this.column_name = column_name;
    }

    @Generated
    public void setData_type(String data_type) {
        this.data_type = data_type;
    }

    @Generated
    public void setData_length(Integer data_length) {
        this.data_length = data_length;
    }

    @Generated
    public void setData_precision(Integer data_precision) {
        this.data_precision = data_precision;
    }

    @Generated
    public void setData_scale(Integer data_scale) {
        this.data_scale = data_scale;
    }

    @Generated
    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    @Generated
    public void setColumn_id(Integer column_id) {
        this.column_id = column_id;
    }

    @Generated
    public void setData_default(String data_default) {
        this.data_default = data_default;
    }

    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Generated
    public void setConstraint_name(String constraint_name) {
        this.constraint_name = constraint_name;
    }

    @Generated
    public void setConstraint_type(String constraint_type) {
        this.constraint_type = constraint_type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabColumn)) {
            return false;
        }
        TabColumn other = (TabColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$data_length = this.getData_length();
        Integer other$data_length = other.getData_length();
        if (this$data_length == null ? other$data_length != null : !((Object)this$data_length).equals(other$data_length)) {
            return false;
        }
        Integer this$data_precision = this.getData_precision();
        Integer other$data_precision = other.getData_precision();
        if (this$data_precision == null ? other$data_precision != null : !((Object)this$data_precision).equals(other$data_precision)) {
            return false;
        }
        Integer this$data_scale = this.getData_scale();
        Integer other$data_scale = other.getData_scale();
        if (this$data_scale == null ? other$data_scale != null : !((Object)this$data_scale).equals(other$data_scale)) {
            return false;
        }
        Integer this$column_id = this.getColumn_id();
        Integer other$column_id = other.getColumn_id();
        if (this$column_id == null ? other$column_id != null : !((Object)this$column_id).equals(other$column_id)) {
            return false;
        }
        String this$table_name = this.getTable_name();
        String other$table_name = other.getTable_name();
        if (this$table_name == null ? other$table_name != null : !this$table_name.equals(other$table_name)) {
            return false;
        }
        String this$column_name = this.getColumn_name();
        String other$column_name = other.getColumn_name();
        if (this$column_name == null ? other$column_name != null : !this$column_name.equals(other$column_name)) {
            return false;
        }
        String this$data_type = this.getData_type();
        String other$data_type = other.getData_type();
        if (this$data_type == null ? other$data_type != null : !this$data_type.equals(other$data_type)) {
            return false;
        }
        String this$nullable = this.getNullable();
        String other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) {
            return false;
        }
        String this$data_default = this.getData_default();
        String other$data_default = other.getData_default();
        if (this$data_default == null ? other$data_default != null : !this$data_default.equals(other$data_default)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        String this$constraint_name = this.getConstraint_name();
        String other$constraint_name = other.getConstraint_name();
        if (this$constraint_name == null ? other$constraint_name != null : !this$constraint_name.equals(other$constraint_name)) {
            return false;
        }
        String this$constraint_type = this.getConstraint_type();
        String other$constraint_type = other.getConstraint_type();
        return !(this$constraint_type == null ? other$constraint_type != null : !this$constraint_type.equals(other$constraint_type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabColumn;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $data_length = this.getData_length();
        result = result * 59 + ($data_length == null ? 43 : ((Object)$data_length).hashCode());
        Integer $data_precision = this.getData_precision();
        result = result * 59 + ($data_precision == null ? 43 : ((Object)$data_precision).hashCode());
        Integer $data_scale = this.getData_scale();
        result = result * 59 + ($data_scale == null ? 43 : ((Object)$data_scale).hashCode());
        Integer $column_id = this.getColumn_id();
        result = result * 59 + ($column_id == null ? 43 : ((Object)$column_id).hashCode());
        String $table_name = this.getTable_name();
        result = result * 59 + ($table_name == null ? 43 : $table_name.hashCode());
        String $column_name = this.getColumn_name();
        result = result * 59 + ($column_name == null ? 43 : $column_name.hashCode());
        String $data_type = this.getData_type();
        result = result * 59 + ($data_type == null ? 43 : $data_type.hashCode());
        String $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : $nullable.hashCode());
        String $data_default = this.getData_default();
        result = result * 59 + ($data_default == null ? 43 : $data_default.hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        String $constraint_name = this.getConstraint_name();
        result = result * 59 + ($constraint_name == null ? 43 : $constraint_name.hashCode());
        String $constraint_type = this.getConstraint_type();
        result = result * 59 + ($constraint_type == null ? 43 : $constraint_type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TabColumn(table_name=" + this.getTable_name() + ", column_name=" + this.getColumn_name() + ", data_type=" + this.getData_type() + ", data_length=" + this.getData_length() + ", data_precision=" + this.getData_precision() + ", data_scale=" + this.getData_scale() + ", nullable=" + this.getNullable() + ", column_id=" + this.getColumn_id() + ", data_default=" + this.getData_default() + ", comments=" + this.getComments() + ", constraint_name=" + this.getConstraint_name() + ", constraint_type=" + this.getConstraint_type() + ")";
    }
}

