/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.mapper;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbColumn;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbIndex;
import org.dromara.autotable.core.strategy.pgsql.data.dbdata.PgsqlDbPrimary;
import org.dromara.autotable.core.utils.DBHelper;

public class PgsqlTablesMapper {
    public String selectTableDescription(final String schema, final String tableName) {
        String sql = "SELECT des.description FROM pg_catalog.pg_description des LEFT JOIN pg_catalog.pg_class clas ON des.objoid = clas.oid LEFT JOIN pg_catalog.pg_namespace nams ON clas.relnamespace = nams.oid WHERE nams.nspname = ':schema' AND clas.relname = ':tableName' AND des.objsubid = 0;";
        return (String)DataSourceManager.useConnection(connection -> (String)DBHelper.queryValue((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }));
    }

    public List<PgsqlDbColumn> selectTableFieldDetail(final String schema, final String tableName) {
        String sql = "SELECT DISTINCT key_col.column_name IS NOT NULL AS primary, des.description, cols.* FROM information_schema.columns cols LEFT JOIN information_schema.key_column_usage key_col ON key_col.column_name = cols.column_name LEFT JOIN pg_catalog.pg_class clas ON clas.relname = cols.table_name AND clas.relnamespace = ( SELECT oid FROM pg_namespace WHERE nspname = cols.table_schema ) LEFT JOIN pg_catalog.pg_description des ON des.objoid = clas.oid AND cols.ordinal_position = des.objsubid WHERE cols.table_schema = ':schema' AND cols.table_name = ':tableName';";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, PgsqlDbColumn.class));
    }

    public List<PgsqlDbIndex> selectTableIndexesDetail(final String schema, final String tableName) {
        String sql = "SELECT DISTINCT des.description, idxs.* FROM pg_catalog.pg_indexes idxs LEFT JOIN pg_catalog.pg_class clas ON idxs.indexname = clas.relname LEFT JOIN pg_catalog.pg_description des ON clas.oid = des.objoid LEFT JOIN pg_catalog.pg_constraint cst ON idxs.indexname = cst.conname WHERE idxs.schemaname = ':schema' AND idxs.tablename = ':tableName' AND cst.contype is null;";
        return (List)DataSourceManager.useConnection(connection -> DBHelper.queryObjectList((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, PgsqlDbIndex.class));
    }

    public PgsqlDbPrimary selectPrimaryKeyName(final String schema, final String tableName) {
        String sql = "SELECT key_col.constraint_name as primary_name, string_agg(key_col.column_name, ',' ORDER BY key_col.ordinal_position ASC) as columns FROM information_schema.key_column_usage key_col WHERE key_col.table_schema = ':schema' AND key_col.table_name = ':tableName' GROUP BY key_col.constraint_name;";
        return (PgsqlDbPrimary)DataSourceManager.useConnection(connection -> (PgsqlDbPrimary)DBHelper.queryObject((Connection)connection, (String)sql, (Map)new HashMap<String, Object>(){
            {
                this.put("tableName", tableName);
                this.put("schema", schema);
            }
        }, PgsqlDbPrimary.class));
    }
}

