/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.builder;

import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;

public class ColumnSqlBuilder {
    public static String buildSql(ColumnMetadata columnMetadata) {
        StringConnectHelper sql = StringConnectHelper.newInstance((String)"{columnName} {typeAndLength} {null} {default}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", () -> columnMetadata.getType().getDefaultFullType());
        if (columnMetadata.isAutoIncrement()) {
            return sql.replace("{null} {default}", "GENERATED ALWAYS AS IDENTITY").toString();
        }
        return sql.replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }
}

