/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.builder;

import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;

public class ColumnSqlBuilder {
    public static String buildSql(ColumnMetadata columnMetadata) {
        StringConnectHelper sql = StringConnectHelper.newInstance((String)"{columnName} {typeAndLength} {null} {default}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", () -> columnMetadata.getType().getDefaultFullType());
        if (columnMetadata.isAutoIncrement()) {
            String pgGenerated = "GENERATED BY DEFAULT AS IDENTITY";
            PropertyConfig.PgsqlConfig.PgsqlPkAutoIncrementType pkAutoIncrementType = AutoTableGlobalConfig.getAutoTableProperties().getPgsql().getPkAutoIncrementType();
            if (pkAutoIncrementType == PropertyConfig.PgsqlConfig.PgsqlPkAutoIncrementType.always) {
                pgGenerated = "GENERATED ALWAYS AS IDENTITY";
            }
            return sql.replace("{null} {default}", pgGenerated).toString();
        }
        return sql.replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }
}

