/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.pgsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresqlDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl.startsWith("jdbc:postgresql") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "PostgreSQL"));
    }

    public DatabaseBuilder.BuildResult build(String jdbcUrl, String username, String password, Set<Class<?>> entityClasses, Consumer<Boolean> dbStatusCallback) {
        String dbName = this.extractDbNameFromUrl(jdbcUrl);
        if (dbName == null) {
            return DatabaseBuilder.BuildResult.of((boolean)false, null);
        }
        PropertyConfig.PgsqlConfig pgsqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getPgsql();
        String execUser = StringUtils.hasText((String)pgsqlConfig.getAdminUser()) ? pgsqlConfig.getAdminUser() : username;
        String execPwd = StringUtils.hasText((String)pgsqlConfig.getAdminPassword()) ? pgsqlConfig.getAdminPassword() : password;
        String adminUrl = jdbcUrl.replaceFirst("/" + dbName, "/postgres");
        boolean createDatabase = false;
        try (Connection conn = DriverManager.getConnection(adminUrl, execUser, execPwd);){
            createDatabase = this.createDatabase(dbStatusCallback, conn, dbName);
            Set<String> schemas = PostgresqlDatabaseBuilder.findAllSchemas(entityClasses);
            if (!schemas.isEmpty()) {
                PostgresqlDatabaseBuilder.createSchemas(conn, schemas);
            }
        }
        catch (SQLException e) {
            log.error("\u521b\u5efaPostgreSQL\u6570\u636e\u5e93\u5931\u8d25", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)createDatabase, (String)dbName);
    }

    private boolean createDatabase(Consumer<Boolean> dbStatusCallback, Connection conn, String dbName) throws SQLException {
        block12: {
            try (PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM pg_database WHERE datname = ?");){
                boolean bl;
                block13: {
                    ps.setString(1, dbName);
                    ResultSet rs = ps.executeQuery();
                    boolean exists = rs.next();
                    dbStatusCallback.accept(exists);
                    if (exists) break block12;
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.executeUpdate(String.format("CREATE DATABASE \"%s\" WITH ENCODING='%s'", dbName, "UTF8"));
                        log.info("\u521b\u5efa PostgreSQL \u6570\u636e\u5e93\uff1a{}", (Object)dbName);
                        bl = true;
                        if (stmt == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return bl;
            }
        }
        return false;
    }

    private static void createSchemas(Connection conn, Set<String> schemas) {
        for (String schemaName : schemas) {
            try {
                PreparedStatement ps = conn.prepareStatement("SELECT schema_name FROM information_schema.schemata WHERE schema_name = ?");
                try {
                    ps.setString(1, schemaName);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        log.info("PostgreSQL schema [{}] \u5df2\u5b58\u5728\uff0c\u65e0\u9700\u521b\u5efa\u3002", (Object)schemaName);
                        continue;
                    }
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.executeUpdate("CREATE SCHEMA \"" + schemaName + "\"");
                        log.info("\u5df2\u6210\u529f\u521b\u5efa PostgreSQL schema [{}]", (Object)schemaName);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException e) {
                log.error("\u68c0\u67e5\u6216\u521b\u5efa schema [{}] \u65f6\u51fa\u9519", (Object)schemaName, (Object)e);
            }
        }
    }

    private static Set<String> findAllSchemas(Set<Class<?>> entityClasses) {
        Set<String> schemas = entityClasses.stream().map(TableMetadataHandler::getTableName).filter(StringUtils::hasText).collect(Collectors.toSet());
        DataSourceManager.useConnection(connection -> {
            try {
                String schema = connection.getSchema();
                if (StringUtils.hasText((String)schema)) {
                    schemas.add(schema);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        });
        return schemas;
    }

    private String extractDbNameFromUrl(String jdbcUrl) {
        Matcher matcher = Pattern.compile("jdbc:postgresql://[^/]+/([^?]+)").matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        log.warn("\u65e0\u6cd5\u4eceurl\u4e2d\u89e3\u6790\u6570\u636e\u5e93\u540d\uff1a{}", (Object)jdbcUrl);
        return null;
    }
}

