/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.pgsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresqlDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl.startsWith("jdbc:postgresql") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "PostgreSQL"));
    }

    public DatabaseBuilder.BuildResult build(String jdbcUrl, String username, String password, Consumer<Boolean> dbStatusCallback) {
        String dbName = this.extractDbNameFromUrl(jdbcUrl);
        if (dbName == null) {
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
        }
        PropertyConfig.MysqlConfig mysqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getMysql();
        String execUser = StringUtils.hasText((String)mysqlConfig.getAdminUser()) ? mysqlConfig.getAdminUser() : username;
        String execPwd = StringUtils.hasText((String)mysqlConfig.getAdminPassword()) ? mysqlConfig.getAdminPassword() : password;
        String adminUrl = jdbcUrl.replaceFirst("/" + dbName, "/postgres");
        try {
            return this.createPgDatabaseIfAbsent(adminUrl, execUser, execPwd, dbName, dbStatusCallback);
        }
        catch (SQLException e) {
            log.error("\u521b\u5efaPostgreSQL\u6570\u636e\u5e93\u5931\u8d25", (Throwable)e);
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
        }
    }

    private String extractDbNameFromUrl(String jdbcUrl) {
        Matcher matcher = Pattern.compile("jdbc:postgresql://[^/]+/([^?]+)").matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        log.warn("\u65e0\u6cd5\u4eceurl\u4e2d\u89e3\u6790\u6570\u636e\u5e93\u540d\uff1a{}", (Object)jdbcUrl);
        return null;
    }

    /*
     * Loose catch block
     */
    private DatabaseBuilder.BuildResult createPgDatabaseIfAbsent(String adminUrl, String username, String password, String dbName, Consumer<Boolean> dbStatusCallback) throws SQLException {
        try (Connection conn = DriverManager.getConnection(adminUrl, username, password);
             PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM pg_database WHERE datname = ?");){
            ps.setString(1, dbName);
            ResultSet rs = ps.executeQuery();
            boolean exists = rs.next();
            dbStatusCallback.accept(exists);
            if (!exists) {
                DatabaseBuilder.BuildResult buildResult;
                block20: {
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.executeUpdate("CREATE DATABASE \"" + dbName + "\" WITH ENCODING='UTF8'");
                        log.info("\u521b\u5efa PostgreSQL \u6570\u636e\u5e93\uff1a{}", (Object)dbName);
                        buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)dbName);
                        if (stmt == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return buildResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

