/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.pgsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresqlDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl.contains(":postgresql://") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "PostgreSQL"));
    }

    public DatabaseBuilder.BuildResult build(String jdbcUrl, String username, String password, Set<Class<?>> entityClasses, Consumer<Boolean> dbStatusCallback) {
        String dbName = this.extractDbNameFromUrl(jdbcUrl);
        if (dbName == null) {
            return DatabaseBuilder.BuildResult.of((boolean)false, null);
        }
        PropertyConfig.PgsqlConfig pgsqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getPgsql();
        String execUser = StringUtils.hasText((String)pgsqlConfig.getAdminUser()) ? pgsqlConfig.getAdminUser() : username;
        String execPwd = StringUtils.hasText((String)pgsqlConfig.getAdminPassword()) ? pgsqlConfig.getAdminPassword() : password;
        String adminUrl = jdbcUrl.replaceFirst("/" + dbName, "/postgres");
        boolean createDatabase = false;
        try (Connection conn = DriverManager.getConnection(adminUrl, execUser, execPwd);){
            createDatabase = this.createDatabase(dbStatusCallback, conn, dbName);
        }
        catch (SQLException e) {
            log.error("\u521b\u5efaPostgreSQL\u6570\u636e\u5e93\u5931\u8d25", (Throwable)e);
        }
        return DatabaseBuilder.BuildResult.of((boolean)createDatabase, (String)dbName);
    }

    private boolean createDatabase(Consumer<Boolean> dbStatusCallback, Connection conn, String dbName) throws SQLException {
        block12: {
            try (PreparedStatement ps = conn.prepareStatement("SELECT 1 FROM pg_database WHERE datname = ?");){
                boolean bl;
                block13: {
                    ps.setString(1, dbName);
                    ResultSet rs = ps.executeQuery();
                    boolean exists = rs.next();
                    dbStatusCallback.accept(exists);
                    if (exists) break block12;
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.executeUpdate(String.format("CREATE DATABASE \"%s\" WITH ENCODING='%s'", dbName, "UTF8"));
                        log.info("\u521b\u5efa PostgreSQL \u6570\u636e\u5e93\uff1a{}", (Object)dbName);
                        bl = true;
                        if (stmt == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return bl;
            }
        }
        return false;
    }

    private String extractDbNameFromUrl(String jdbcUrl) {
        Matcher matcher = Pattern.compile(".*:postgresql://[^/]+/([^?]+)").matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        log.warn("\u65e0\u6cd5\u4eceurl\u4e2d\u89e3\u6790\u6570\u636e\u5e93\u540d\uff1a{}", (Object)jdbcUrl);
        return null;
    }
}

