/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.pgsql.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.annotation.enums.IndexSortTypeEnum;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.pgsql.builder.ColumnSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String createTableSql = CreateTableSqlBuilder.getCreateTableSql(tableMetadata);
        List indexMetadataList = tableMetadata.getIndexMetadataList();
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, indexMetadataList);
        String addCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(tableMetadata);
        return createTableSql + "\n" + createIndexSql + "\n" + addCommentSql;
    }

    public static String getCreateIndexSql(String schema, String tableName, List<IndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(pgsqlIndexMetadata -> CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, pgsqlIndexMetadata)).collect(Collectors.joining("\n"));
    }

    public static String getCreateIndexSql(String schema, String tableName, IndexMetadata pgsqlIndexMetadata) {
        return StringConnectHelper.newInstance((String)"CREATE {indexType}INDEX {indexName} ON {schemaTableName} {method} ({columns});").replace("{indexType}", pgsqlIndexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE " : "").replace("{indexName}", IStrategy.wrapIdentifiers((String)pgsqlIndexMetadata.getName())).replace("{schemaTableName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, tableName})).replace("{method}", CreateTableSqlBuilder.getMethod(pgsqlIndexMetadata.getMethod())).replace("{columns}", () -> {
            List columnParams = pgsqlIndexMetadata.getColumns();
            return columnParams.stream().map(column -> "{column}{sortMode}".replace("{column}", IStrategy.wrapIdentifiers((String)column.getColumn())).replace("{sortMode}", column.getSort() == null || column.getSort() == IndexSortTypeEnum.ASC ? "" : " " + column.getSort().name())).collect(Collectors.joining(", "));
        }).toString();
    }

    private static String getMethod(String method) {
        return "USING " + (StringUtils.hasText((String)method) ? method.toLowerCase() : "btree");
    }

    private static String getAddColumnCommentSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String comment = tableMetadata.getComment();
        List columnMetadataList = tableMetadata.getColumnMetadataList();
        List indexMetadataList = tableMetadata.getIndexMetadataList();
        return CreateTableSqlBuilder.getAddColumnCommentSql(schema, tableName, comment, columnMetadataList.stream().collect(Collectors.toMap(ColumnMetadata::getName, ColumnMetadata::getComment)), indexMetadataList.stream().collect(Collectors.toMap(IndexMetadata::getName, IndexMetadata::getComment)));
    }

    public static String getAddColumnCommentSql(String schema, String tableName, String tableComment, Map<String, String> columnCommentMap, Map<String, String> indexCommentMap) {
        ArrayList<String> commentList = new ArrayList<String>();
        if (StringUtils.hasText((String)tableComment)) {
            String addTableComment = "COMMENT ON TABLE {schemaTableName} IS '{comment}';".replace("{schemaTableName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, tableName})).replace("{comment}", tableComment);
            commentList.add(addTableComment);
        }
        columnCommentMap.entrySet().stream().map(columnComment -> "COMMENT ON COLUMN {schemaTableName}.{columnName} IS '{comment}';".replace("{schemaTableName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, tableName})).replace("{columnName}", IStrategy.wrapIdentifiers((String)((String)columnComment.getKey()))).replace("{comment}", (CharSequence)columnComment.getValue())).forEach(commentList::add);
        indexCommentMap.entrySet().stream().map(indexComment -> "COMMENT ON INDEX {schemaIndexName} IS '{comment}';".replace("{schemaIndexName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, (String)indexComment.getKey()})).replace("{comment}", (CharSequence)indexComment.getValue())).forEach(commentList::add);
        return String.join((CharSequence)"\n", commentList);
    }

    private static String getCreateTableSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String name = tableMetadata.getTableName();
        List columnMetadataList = tableMetadata.getColumnMetadataList();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        columnList.add(columnMetadataList.stream().map(ColumnSqlBuilder::buildSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            columnList.add(primaryKeySql);
        }
        String addSql = columnList.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE {schemaTableName} ({alterColumnList});".replace("{schemaTableName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, name})).replace("{alterColumnList}", addSql);
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", IStrategy.customConcatWrapIdentifiers((String)",", primaries));
    }
}

