/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.sqlite.builder;

import java.lang.reflect.Field;
import java.util.HashSet;
import lombok.Generated;
import org.dromara.autotable.annotation.ColumnDefault;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.strategy.sqlite.data.SqliteTypeHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteColumnMetadataBuilder
extends ColumnMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqliteColumnMetadataBuilder.class);
    private final HashSet<String> defaultValueFuncs = new HashSet();

    public SqliteColumnMetadataBuilder() {
        super("SQLite");
        this.defaultValueFuncs.add("CURRENT_DATE");
        this.defaultValueFuncs.add("CURRENT_TIME");
        this.defaultValueFuncs.add("CURRENT_TIMESTAMP");
    }

    protected DatabaseTypeAndLength getTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        DatabaseTypeAndLength typeAndLength = super.getTypeAndLength(databaseDialect, clazz, field);
        SqliteColumnMetadataBuilder.fixTypeAndLength(typeAndLength);
        return typeAndLength;
    }

    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        String defaultValue = super.getDefaultValue(typeAndLength, columnDefault);
        if (StringUtils.hasText((String)defaultValue)) {
            boolean isBooleanType;
            boolean bl = isBooleanType = SqliteTypeHelper.isInteger(typeAndLength) && ("true".equalsIgnoreCase(defaultValue) || "false".equalsIgnoreCase(defaultValue));
            if (isBooleanType) {
                defaultValue = Boolean.parseBoolean(defaultValue) ? "1" : "0";
            }
            if (this.defaultValueFuncs.contains(defaultValue)) {
                return defaultValue;
            }
            if (SqliteTypeHelper.isText(typeAndLength) && !defaultValue.isEmpty() && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = "'" + defaultValue + "'";
            }
        }
        return defaultValue;
    }

    private static void fixTypeAndLength(DatabaseTypeAndLength typeAndLength) {
        String type = typeAndLength.getType().toLowerCase();
        if (type.contains("int")) {
            type = "integer";
        }
        if (type.contains("char") || type.contains("clob") || type.contains("text")) {
            type = "text";
        }
        if (type.contains("blob")) {
            type = "blob";
        }
        if (type.contains("real") || type.contains("floa") || type.contains("doub")) {
            type = "real";
        }
        typeAndLength.setType(type);
    }
}

