/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.sqlite.mapper;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.utils.DBHelper;
import org.dromara.autotable.strategy.sqlite.data.dbdata.SqliteColumns;
import org.dromara.autotable.strategy.sqlite.data.dbdata.SqliteMaster;

public class SqliteTablesMapper {
    public String queryBuildTableSql(String tableName) {
        return (String)DataSourceManager.useConnection(connection -> {
            String sql = "select `sql` from sqlite_master where type='table' and name=':tableName';";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tableName", tableName);
            return (String)DBHelper.queryValue((Connection)connection, (String)sql, params);
        });
    }

    public List<SqliteMaster> queryBuildIndexSql(String tableName) {
        return (List)DataSourceManager.useConnection(connection -> {
            String sql = "select * from sqlite_master where type='index' and tbl_name=':tableName';";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tableName", tableName);
            return DBHelper.queryObjectList((Connection)connection, (String)sql, params, SqliteMaster.class);
        });
    }

    public List<SqliteColumns> queryTableColumns(String tableName) {
        return (List)DataSourceManager.useConnection(connection -> {
            String sql = "pragma table_info(':tableName');";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tableName", tableName);
            return DBHelper.queryObjectList((Connection)connection, (String)sql, params, SqliteColumns.class);
        });
    }
}

