/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.support.springdoc;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.dromara.autotable.annotation.AutoColumn;
import org.dromara.autotable.annotation.ColumnComment;
import org.dromara.autotable.core.utils.StringUtils;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springframework.core.MethodParameter;

public class AutoTableParameterCustomizer
implements ParameterCustomizer {
    public Parameter customize(Parameter parameter, MethodParameter methodParameter) {
        if (parameter == null || methodParameter == null) {
            return parameter;
        }
        Annotation[] annotations = methodParameter.getParameterAnnotations();
        if (annotations.length < 1) {
            return parameter;
        }
        ColumnComment columnComment = Arrays.stream(annotations).filter(it -> it instanceof ColumnComment).map(it -> (ColumnComment)it).findAny().orElse(null);
        if (columnComment != null && StringUtils.hasText((String)columnComment.value())) {
            return parameter.description(columnComment.value());
        }
        AutoColumn autoColumn = Arrays.stream(annotations).filter(it -> it instanceof AutoColumn).map(it -> (AutoColumn)it).findAny().orElse(null);
        if (autoColumn != null && StringUtils.hasText((String)autoColumn.comment())) {
            return parameter.description(autoColumn.comment());
        }
        return parameter;
    }
}

