/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.daxpay.single.sdk.net;

import cn.hutool.core.util.StrUtil;
import org.dromara.daxpay.single.sdk.code.SignTypeEnum;

public class DaxPayConfig {
    private String serviceUrl;
    private String appId;
    private SignTypeEnum signType;
    private String signSecret;
    private int reqTimeout;

    public String getServiceUrl() {
        return StrUtil.removeSuffix((CharSequence)this.serviceUrl, (CharSequence)"/");
    }

    private static SignTypeEnum $default$signType() {
        return SignTypeEnum.HMAC_SHA256;
    }

    private static int $default$reqTimeout() {
        return 30000;
    }

    DaxPayConfig(String serviceUrl, String appId, SignTypeEnum signType, String signSecret, int reqTimeout) {
        this.serviceUrl = serviceUrl;
        this.appId = appId;
        this.signType = signType;
        this.signSecret = signSecret;
        this.reqTimeout = reqTimeout;
    }

    public static DaxPayConfigBuilder builder() {
        return new DaxPayConfigBuilder();
    }

    public String getAppId() {
        return this.appId;
    }

    public SignTypeEnum getSignType() {
        return this.signType;
    }

    public String getSignSecret() {
        return this.signSecret;
    }

    public int getReqTimeout() {
        return this.reqTimeout;
    }

    public static class DaxPayConfigBuilder {
        private String serviceUrl;
        private String appId;
        private boolean signType$set;
        private SignTypeEnum signType$value;
        private String signSecret;
        private boolean reqTimeout$set;
        private int reqTimeout$value;

        DaxPayConfigBuilder() {
        }

        public DaxPayConfigBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public DaxPayConfigBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public DaxPayConfigBuilder signType(SignTypeEnum signType) {
            this.signType$value = signType;
            this.signType$set = true;
            return this;
        }

        public DaxPayConfigBuilder signSecret(String signSecret) {
            this.signSecret = signSecret;
            return this;
        }

        public DaxPayConfigBuilder reqTimeout(int reqTimeout) {
            this.reqTimeout$value = reqTimeout;
            this.reqTimeout$set = true;
            return this;
        }

        public DaxPayConfig build() {
            SignTypeEnum signType$value = this.signType$value;
            if (!this.signType$set) {
                signType$value = DaxPayConfig.$default$signType();
            }
            int reqTimeout$value = this.reqTimeout$value;
            if (!this.reqTimeout$set) {
                reqTimeout$value = DaxPayConfig.$default$reqTimeout();
            }
            return new DaxPayConfig(this.serviceUrl, this.appId, signType$value, this.signSecret, reqTimeout$value);
        }

        public String toString() {
            return "DaxPayConfig.DaxPayConfigBuilder(serviceUrl=" + this.serviceUrl + ", appId=" + this.appId + ", signType$value=" + (Object)((Object)this.signType$value) + ", signSecret=" + this.signSecret + ", reqTimeout$value=" + this.reqTimeout$value + ")";
        }
    }
}

