/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.daxpay.single.sdk.net;

import cn.hutool.http.ContentType;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import java.util.Objects;
import org.dromara.daxpay.single.sdk.code.SignTypeEnum;
import org.dromara.daxpay.single.sdk.net.DaxPayConfig;
import org.dromara.daxpay.single.sdk.net.DaxPayRequest;
import org.dromara.daxpay.single.sdk.response.DaxPayResult;
import org.dromara.daxpay.single.sdk.util.JsonUtil;
import org.dromara.daxpay.single.sdk.util.PaySignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaxPayKit {
    private static final Logger log = LoggerFactory.getLogger(DaxPayKit.class);
    private static DaxPayConfig config;

    public static void initConfig(DaxPayConfig config) {
        log.debug("DaxPayKit\u521d\u59cb\u5316...");
        DaxPayKit.config = config;
    }

    public static <T> DaxPayResult<T> execute(DaxPayRequest<T> request) {
        return DaxPayKit.execute(request, true);
    }

    public static <T> DaxPayResult<T> execute(DaxPayRequest<T> request, boolean sign) {
        String body;
        if (Objects.isNull(request.getAppId())) {
            request.setAppId(config.getAppId());
        }
        if (sign) {
            if (Objects.equals((Object)SignTypeEnum.MD5, (Object)config.getSignType())) {
                request.setSign(PaySignUtil.md5Sign(request, config.getSignSecret()));
            } else if (Objects.equals((Object)SignTypeEnum.HMAC_SHA256, (Object)config.getSignType())) {
                request.setSign(PaySignUtil.hmacSha256Sign(request, config.getSignSecret()));
            } else if (Objects.equals((Object)SignTypeEnum.SM3, (Object)config.getSignType())) {
                request.setSign(PaySignUtil.sm3Sign(request, config.getSignSecret()));
            }
        }
        String data = JsonUtil.toJsonStr(request);
        log.debug("\u8bf7\u6c42\u53c2\u6570:{}", (Object)data);
        String path = config.getServiceUrl() + request.path();
        try (HttpResponse execute = HttpUtil.createPost((String)path).body(data, ContentType.JSON.getValue()).timeout(config.getReqTimeout()).execute();){
            if (execute.getStatus() != 200) {
                log.error("\u8bf7\u6c42\u7b2c\u652f\u4ed8\u7f51\u5173\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u914d\u7f6e\u7684\u652f\u4ed8\u7f51\u5173\u5730\u5740\u662f\u5426\u6b63\u5e38");
                throw new HttpException("\u8bf7\u6c42\u5931\u8d25\uff0c\u5185\u90e8\u5f02\u5e38");
            }
            body = execute.body();
        }
        log.debug("\u54cd\u5e94\u53c2\u6570:{}", (Object)body);
        return request.toModel(body);
    }

    private DaxPayKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

