/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.daxpay.single.sdk.util;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.dromara.daxpay.single.sdk.util.JsonUtil;

public final class PaySignUtil {
    private static final String FIELD_SIGN = "sign";

    public static Map<String, String> toMap(Object object) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        PaySignUtil.toMap(object, map);
        return map;
    }

    private static void toMap(Object object, Map<String, String> map) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(object);
                if (fieldValue == null) continue;
                if (ClassUtil.isBasicType(field.getType()) || field.getType().equals(String.class)) {
                    String fieldValueString = String.valueOf(fieldValue);
                    map.put(fieldName, fieldValueString);
                    continue;
                }
                if (field.getType().equals(LocalDateTime.class)) {
                    LocalDateTime localDateTime = (LocalDateTime)fieldValue;
                    String datetime = LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd HH:mm:ss");
                    map.put(fieldName, datetime);
                    continue;
                }
                if (Map.class.isAssignableFrom(field.getType())) {
                    TreeMap m = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    m.putAll((Map)fieldValue);
                    map.put(fieldName, JsonUtil.toJsonStr(m));
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    BigDecimal bigDecimal = (BigDecimal)fieldValue;
                    String decimalString = bigDecimal.stripTrailingZeros().toPlainString();
                    map.put(fieldName, decimalString);
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection collection = (Collection)fieldValue;
                    if (collection.isEmpty()) continue;
                    List maps = collection.stream().filter(Objects::nonNull).map(item -> {
                        TreeMap<String, String> nestedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                        PaySignUtil.toMap(item, nestedMap);
                        return nestedMap;
                    }).collect(Collectors.toList());
                    map.put(fieldName, JsonUtil.toJsonStr(maps));
                    continue;
                }
                TreeMap<String, String> nestedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                PaySignUtil.toMap(fieldValue, nestedMap);
                String nestedJson = JsonUtil.toJsonStr(fieldValue);
                map.put(fieldName, nestedJson);
            }
        }
    }

    public static String createLinkString(Map<String, String> params) {
        String connStr = "&";
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                content.append(key).append("=").append(value);
                continue;
            }
            content.append(key).append("=").append(value).append(connStr);
        }
        String s = content.toString();
        s = StrUtil.replace((CharSequence)s, (CharSequence)"\\", (CharSequence)"");
        s = StrUtil.replace((CharSequence)s, (CharSequence)"\"", (CharSequence)"");
        return s;
    }

    public static String md5(String data) {
        return SecureUtil.md5((String)data);
    }

    public static String hmacSha256(String data, String signKey) {
        return SecureUtil.hmac((HmacAlgorithm)HmacAlgorithm.HmacSHA256, (String)signKey).digestHex(data);
    }

    public static String sm3(String data) {
        return SmUtil.sm3((String)data);
    }

    public static String signString(Object object, String signKey) {
        Map<String, String> map = PaySignUtil.toMap(object);
        map.remove(FIELD_SIGN);
        String data = PaySignUtil.createLinkString(map);
        return data + "&key=" + signKey;
    }

    public static String md5Sign(Object object, String signKey) {
        String data = PaySignUtil.signString(object, signKey);
        return PaySignUtil.md5(data);
    }

    public static String hmacSha256Sign(Object object, String signKey) {
        String data = PaySignUtil.signString(object, signKey);
        return PaySignUtil.hmacSha256(data, signKey);
    }

    public static String sm3Sign(Object object, String signKey) {
        String data = PaySignUtil.signString(object, signKey);
        return PaySignUtil.sm3(data);
    }

    public static boolean verifyMd5Sign(Object object, String signKey, String sign) {
        String md5Sign = PaySignUtil.md5Sign(object, signKey);
        return md5Sign.equals(sign);
    }

    public static boolean verifyHmacSha256Sign(Object object, String signKey, String sign) {
        String hmacSha256Sign = PaySignUtil.hmacSha256Sign(object, signKey);
        return hmacSha256Sign.equals(sign);
    }

    public static boolean verifySm3Sign(Object object, String signKey, String sign) {
        String sm3Sign = PaySignUtil.sm3Sign(object, signKey);
        return sm3Sign.equals(sign);
    }

    private PaySignUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

