/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.example.service.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.OrderedDtpExecutor;
import org.dromara.dynamictp.core.support.task.runnable.NamedRunnable;
import org.dromara.dynamictp.core.support.task.runnable.OrderedRunnable;
import org.dromara.dynamictp.example.service.TestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class TestServiceImpl
implements TestService {
    private static final Logger log = LoggerFactory.getLogger(TestServiceImpl.class);
    private final ThreadPoolExecutor jucThreadPoolExecutor;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final DtpExecutor eagerDtpExecutor;
    private final ScheduledExecutorService scheduledDtpExecutor;
    private final OrderedDtpExecutor orderedDtpExecutor;

    public TestServiceImpl(ThreadPoolExecutor jucThreadPoolExecutor, ThreadPoolTaskExecutor threadPoolTaskExecutor, DtpExecutor eagerDtpExecutor, ScheduledExecutorService scheduledDtpExecutor, OrderedDtpExecutor orderedDtpExecutor) {
        this.jucThreadPoolExecutor = jucThreadPoolExecutor;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.eagerDtpExecutor = eagerDtpExecutor;
        this.scheduledDtpExecutor = scheduledDtpExecutor;
        this.orderedDtpExecutor = orderedDtpExecutor;
    }

    @Override
    public void testJucTp() {
        for (int i = 0; i < 10; ++i) {
            this.jucThreadPoolExecutor.execute(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.info("i am a jucThreadPoolExecutor's task");
            });
        }
    }

    @Override
    public void testSpringTp() {
        for (int i = 0; i < 10; ++i) {
            this.threadPoolTaskExecutor.execute(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.info("i am a threadPoolTaskExecutor's task");
            });
        }
    }

    @Override
    public void testCommonDtp() {
        Executor dtpExecutor1 = DtpRegistry.getExecutor((String)"dtpExecutor1");
        for (int i = 0; i < 10; ++i) {
            dtpExecutor1.execute((Runnable)NamedRunnable.of(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.info("i am a dtpExecutor's task");
            }, (String)("task" + i)));
        }
    }

    @Override
    public void testEagerDtp() {
        for (int i = 0; i < 10; ++i) {
            this.eagerDtpExecutor.execute(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.info("i am a eagerDtpExecutor's task");
            });
        }
    }

    @Override
    public void testScheduledDtp() {
        this.scheduledDtpExecutor.scheduleAtFixedRate(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("i am a scheduledDtpExecutor's task");
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void testOrderedDtp() {
        for (int i = 0; i < 10; ++i) {
            this.orderedDtpExecutor.execute((Runnable)((Object)new TestOrderedRunnable(new UserInfo(i, "dtp" + i))));
        }
    }

    public static class UserInfo {
        private long uid;
        private String name;

        public long getUid() {
            return this.uid;
        }

        public String getName() {
            return this.name;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserInfo)) {
                return false;
            }
            UserInfo other = (UserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUid() != other.getUid()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $uid = this.getUid();
            result = result * 59 + (int)($uid >>> 32 ^ $uid);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "TestServiceImpl.UserInfo(uid=" + this.getUid() + ", name=" + this.getName() + ")";
        }

        public UserInfo(long uid, String name) {
            this.uid = uid;
            this.name = name;
        }
    }

    public static class TestOrderedRunnable
    implements OrderedRunnable {
        private final UserInfo userInfo;

        public TestOrderedRunnable(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public Object hashKey() {
            return this.userInfo.getUid();
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("i am a orderedDtpExecutor's task, userInfo: {}", (Object)this.userInfo);
        }
    }
}

