/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.jvmti;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang3.StringUtils;

public class NativeUtil {
    private static final String NATIVE_FOLDER_PATH_PREFIX = "dtp_native_";
    private static File temporaryDir;

    private NativeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String filename) throws IOException {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new IllegalArgumentException("The filename cannot be null");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtil.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.deleteOnExit();
        }
        File temp = new File(temporaryDir, filename);
        try (InputStream is = NativeUtil.class.getClassLoader().getResourceAsStream(filename);){
            assert (is != null);
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Files.delete(temp.toPath());
            throw e;
        }
        catch (NullPointerException e) {
            Files.delete(temp.toPath());
            throw new FileNotFoundException("File " + filename + " was not found inside JAR.");
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        finally {
            temp.deleteOnExit();
        }
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

