/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.trans.service.impl;

import java.lang.annotation.Annotation;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.anno.TransDefaultSett;
import org.dromara.core.trans.vo.TransPojo;
import org.dromara.core.trans.vo.VO;

class SimpleTrans
implements Trans {
    private Trans anno;
    private String[] fields = new String[0];
    private String alias = "";
    private String uniqueField = "";
    private String dataSource = "";

    public SimpleTrans(Trans anno) {
        Class<? extends VO> clazz;
        this.anno = anno;
        if ("simple".equals(this.type()) && (clazz = this.target()) != null && clazz.isAnnotationPresent(TransDefaultSett.class)) {
            TransDefaultSett transDefaultSett = clazz.getAnnotation(TransDefaultSett.class);
            this.fields = transDefaultSett.defaultFields();
            this.alias = transDefaultSett.defaultAlias();
            this.uniqueField = transDefaultSett.uniqueField();
            this.dataSource = transDefaultSett.dataSource();
        }
    }

    public String type() {
        return this.anno.type();
    }

    public String key() {
        return this.anno.key();
    }

    public String ref() {
        return this.anno.ref();
    }

    public String[] refs() {
        return this.anno.refs();
    }

    public Class<? extends VO> target() {
        try {
            return this.anno.target() == TransPojo.class ? Class.forName(this.anno.targetClassName()) : this.anno.target();
        }
        catch (ClassNotFoundException e) {
            if ("rpc".equals(this.type())) {
                return TransPojo.class;
            }
            throw new RuntimeException(e);
        }
    }

    public String[] fields() {
        if (this.anno.fields().length != 0 || this.fields == null) {
            return this.anno.fields();
        }
        return this.anno.fields().length != 0 || this.fields == null ? this.anno.fields() : this.fields;
    }

    public String alias() {
        return this.anno.alias().length() != 0 || "".equals(this.alias) ? this.anno.alias() : this.alias;
    }

    public String serviceName() {
        return this.anno.serviceName();
    }

    public String serviceContextPath() {
        return this.anno.serviceContextPath();
    }

    public String targetClassName() {
        return this.anno.targetClassName();
    }

    public String customeBeanFuncName() {
        return this.anno.customeBeanFuncName();
    }

    public String dataSource() {
        return this.anno.dataSource().length() != 0 || "".equals(this.dataSource) ? this.anno.dataSource() : this.dataSource;
    }

    public String uniqueField() {
        return this.anno.uniqueField().length() != 0 || "".equals(this.uniqueField) ? this.anno.uniqueField() : this.uniqueField;
    }

    public int sort() {
        return this.anno.sort();
    }

    public Class<? extends Annotation> annotationType() {
        return this.anno.annotationType();
    }
}

