/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.trans.untrans.driver;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.dromara.core.trans.anno.UnTrans;
import org.dromara.trans.service.impl.SimpleTransService;
import org.dromara.trans.untrans.util.DBUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonUnTransDriver
implements SimpleTransService.SimpleUnTransDiver {
    @Autowired
    private DataSource datasource;

    public Map<String, String> getUnTransMap(UnTrans unTrans, List<String> groupKeys) {
        String groupKeyConcat = unTrans.columns().length > 1 ? "CONCAT(" + Arrays.stream(unTrans.columns()).collect(Collectors.joining(",'/',")) + ")" : unTrans.columns()[0];
        String sql = MessageFormat.format("SELECT {0} AS groupKey,{1} as uniqueKey FROM {2} WHERE {3} IN ", groupKeyConcat, unTrans.uniqueColumn(), unTrans.tableName(), groupKeyConcat);
        try {
            return DBUtil.query(sql, groupKeys, this.datasource.getConnection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUnTransResult(UnTrans unTrans, String groupKey) {
        Map<String, String> untransMap = this.getUnTransMap(unTrans, Arrays.asList(groupKey));
        return untransMap.get(groupKey);
    }
}

