/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.matrixTools;

import java.util.ArrayList;
import java.util.List;
import org.dromara.matrixTools.MatrixOperation;

public class Matrix
extends MatrixOperation {
    private double[][] matrix;
    private int x;
    private int y;
    private boolean isRowVector = false;
    private boolean isVector = false;
    private boolean isZero = false;
    private List<Coordinate> coordinateRoot;
    private double defNub = 0.0;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Matrix(int x, int y) {
        this.matrix = new double[x][y];
        this.x = x;
        this.y = y;
        this.setState(x, y);
    }

    private void setState(int x, int y) {
        if (x == 1 && y == 1) {
            this.isZero = true;
            this.isVector = true;
        } else if (x == 1 || y == 1) {
            this.isVector = true;
            this.isRowVector = x == 1;
        }
    }

    public double getSigma() {
        double sigma = 0.0;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                sigma += this.matrix[i][j];
            }
        }
        return sigma;
    }

    public double getAVG() {
        double sigma = 0.0;
        int s = this.x * this.y;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                sigma += this.matrix[i][j];
            }
        }
        return sigma /= (double)s;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public boolean isRowVector() {
        return this.isRowVector;
    }

    public boolean isVector() {
        return this.isVector;
    }

    public boolean isZero() {
        return this.isZero;
    }

    public void clear() {
        this.matrix = new double[this.x][this.y];
    }

    public Matrix(int x, int y, String matr) throws Exception {
        this.matrix = new double[x][y];
        this.x = x;
        this.y = y;
        this.setState(x, y);
        this.setAll(matr);
    }

    private boolean isDo(Coordinate coordinates, int i, int j) {
        boolean isOk = false;
        if (coordinates != null) {
            for (Coordinate coordinate : coordinates.coordinateList) {
                if (coordinate.x != i || coordinate.y != j) continue;
                isOk = true;
                break;
            }
        }
        return isOk;
    }

    private boolean findRout(Coordinate coordinate, int j, int initi, boolean isDown) {
        for (int i = 0; i < this.x && isDown; ++i) {
            boolean isOk;
            int row = i;
            if (coordinate == null) {
                row = initi;
            }
            boolean bl = isOk = this.isNext(coordinate, row, true) && !this.isDo(coordinate, row, j);
            if (isOk) {
                Coordinate coordinateNext = new Coordinate(coordinate, row, j);
                if (coordinate != null) {
                    coordinate.coordinateList.add(coordinateNext);
                } else {
                    this.coordinateRoot.add(coordinateNext);
                }
                if (coordinateNext.y < this.y - 1) {
                    isDown = this.findRout(coordinateNext, ++j, initi, isDown);
                    continue;
                }
                if (coordinate != null && coordinateNext.y > 1 && coordinateNext.x == this.x - 1) {
                    isDown = this.findRout(coordinate.father, --j, initi, isDown);
                    continue;
                }
                if (coordinateNext.y != 1) continue;
                isDown = false;
                break;
            }
            if (i == this.x - 1 && j > 1) {
                isDown = this.findRout(coordinate.father, --j, initi, isDown);
                continue;
            }
            if (j != 1 || i != this.x - 1) continue;
            isDown = false;
            break;
        }
        return isDown;
    }

    private boolean isNext(Coordinate coordinate, int i, boolean isOk) {
        if (coordinate == null) {
            return true;
        }
        if (isOk) {
            if (coordinate.x != i) {
                isOk = this.isNext(coordinate.father, i, true);
            } else {
                return false;
            }
        }
        return isOk;
    }

    private void defCalculation(List<Coordinate> coordinates) {
        for (Coordinate coordinate : coordinates) {
            if (!coordinate.coordinateList.isEmpty()) {
                this.defCalculation(coordinate.coordinateList);
                continue;
            }
            this.mulFather(coordinate, 1.0, new ArrayList<Coordinate>());
        }
    }

    private double mulFather(Coordinate coordinate, double element, List<Coordinate> div) {
        div.add(coordinate);
        element = this.matrix[coordinate.x][coordinate.y] * element;
        if (coordinate.father != null) {
            element = this.mulFather(coordinate.father, element, div);
        } else {
            this.defNub = this.parity(div) ? (this.defNub += element) : (this.defNub -= element);
            div.clear();
            element = 1.0;
        }
        return element;
    }

    public double getDet() throws Exception {
        if (this.x == this.y) {
            this.coordinateRoot = new ArrayList<Coordinate>();
            for (int i = 0; i < this.x; ++i) {
                this.findRout(null, 0, i, true);
            }
        } else {
            throw new Exception("Matrix is not Square");
        }
        this.defCalculation(this.coordinateRoot);
        return this.defNub;
    }

    private boolean parity(List<Coordinate> list) {
        int cloInv;
        boolean parity = true;
        double[] row = new double[list.size()];
        double[] clo = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            row[i] = list.get((int)i).x + 1;
            clo[i] = list.get((int)i).y + 1;
        }
        int rowInv = this.inverseNumber(row);
        int inverserNumber = rowInv + (cloInv = this.inverseNumber(clo));
        if (inverserNumber % 2 != 0) {
            parity = false;
        }
        return parity;
    }

    public void setAll(String messages) throws Exception {
        String[] message = messages.split("#");
        if (this.x == message.length) {
            for (int i = 0; i < message.length; ++i) {
                String mes = message[i];
                String[] me = mes.substring(1, mes.length() - 1).split(",");
                if (this.y == me.length) {
                    this.y = me.length;
                    for (int j = 0; j < this.y; ++j) {
                        this.matrix[i][j] = Double.parseDouble(me[j]);
                    }
                    continue;
                }
                this.matrix = null;
                throw new Exception("matrix column is not equals");
            }
        } else {
            throw new Exception("matrix row is not equals");
        }
    }

    public Matrix getSonOfMatrix(int x, int y, int xSize, int ySize) {
        Matrix myMatrix = new Matrix(xSize, ySize);
        int xr = 0;
        int yr = 0;
        try {
            for (int i = 0; i < xSize; ++i) {
                xr = i + x;
                for (int j = 0; j < ySize; ++j) {
                    yr = j + y;
                    if (this.x <= xr || this.y <= yr) {
                        throw new Exception("xr:" + xr + ",yr:" + yr + ",x:" + this.x + ",y:" + this.y + ",xSize:" + xSize + ",ySize:" + ySize + ",x:" + x + ",y:" + y);
                    }
                    myMatrix.setNub(i, j, this.matrix[xr][yr]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("xr:" + xr + ",yr:" + yr);
            e.printStackTrace();
        }
        return myMatrix;
    }

    public Matrix getRow(int x) throws Exception {
        Matrix myMatrix = new Matrix(1, this.y);
        for (int i = 0; i < this.y; ++i) {
            myMatrix.setNub(0, i, this.matrix[x][i]);
        }
        return myMatrix;
    }

    public Matrix getColumn(int y) throws Exception {
        Matrix myMatrix = new Matrix(this.x, 1);
        for (int i = 0; i < this.x; ++i) {
            myMatrix.setNub(i, 0, this.matrix[i][y]);
        }
        return myMatrix;
    }

    public String getString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.x; ++i) {
            builder.append(i + ":[");
            for (int j = 0; j < this.y; ++j) {
                double number = this.matrix[i][j];
                if (j == 0) {
                    builder.append(number);
                    continue;
                }
                builder.append("," + number);
            }
            builder.append("]\r\n");
        }
        return builder.toString();
    }

    public String getPositionString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.x; ++i) {
            builder.append(i + ":[");
            for (int j = 0; j < this.y; ++j) {
                double number = this.matrix[i][j];
                if (j == 0) {
                    builder.append(number);
                    continue;
                }
                builder.append("," + j + ":" + number);
            }
            builder.append("]\r\n");
        }
        return builder.toString();
    }

    public void setNub(int x, int y, double number) throws Exception {
        if (this.x <= x || this.y <= y || x < 0 || y < 0) {
            throw new Exception("setNub matrix length too little x:" + x + ",y:" + y);
        }
        this.matrix[x][y] = number;
    }

    public Matrix copy() throws Exception {
        Matrix myMatrix = new Matrix(this.x, this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                myMatrix.setNub(i, j, this.matrix[i][j]);
            }
        }
        return myMatrix;
    }

    public double getNumber(int x, int y) throws Exception {
        if (this.x > x && this.y > y && x >= 0 && y >= 0) {
            return this.matrix[x][y];
        }
        System.out.println("x==" + x + ",y==" + y + ",maxX:" + this.x + ",maxY:" + this.y);
        throw new Exception("getNumber matrix length too little x:" + x + ",y:" + y);
    }

    public double getSigmaByVector(boolean isRow, int index) throws Exception {
        double sigma = 0.0;
        if (index >= 0 && (isRow && this.x > index || !isRow && this.y > index)) {
            if (isRow) {
                for (int i = 0; i < this.y; ++i) {
                    sigma = this.matrix[index][i] + sigma;
                }
            } else {
                for (int i = 0; i < this.x; ++i) {
                    sigma = this.matrix[i][index] + sigma;
                }
            }
        } else {
            throw new Exception("index \u6570\u503c\u4e0b\u6807\u6ea2\u51fa:" + index);
        }
        return sigma;
    }

    class Coordinate {
        Coordinate father;
        List<Coordinate> coordinateList;
        int x;
        int y;

        Coordinate(Coordinate father, int x, int y) {
            this.x = x;
            this.y = y;
            this.father = father;
            this.coordinateList = new ArrayList<Coordinate>();
        }
    }
}

