/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.matrixTools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixMulAccelerate;

public class MatrixOperation {
    private final int coreNumber;
    private ExecutorService POOL;

    public MatrixOperation() {
        this.coreNumber = 1;
    }

    public MatrixOperation(int coreNumber) {
        this.coreNumber = coreNumber;
        if (coreNumber > 1) {
            this.POOL = Executors.newFixedThreadPool(coreNumber);
        }
    }

    public List<Double> rowVectorToList(Matrix matrix) throws Exception {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int j = 0; j < matrix.getY(); ++j) {
            list.add(matrix.getNumber(0, j));
        }
        return list;
    }

    public Matrix add(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix1.getY());
            int x = matrix1.getX();
            int y = matrix1.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) + matrix2.getNumber(i, j));
                }
            }
            return matrix;
        }
        throw new Exception("matrix is not equals");
    }

    public void center(Matrix matrix) throws Exception {
        double avgValue = matrix.getAVG();
        this.mathSub(matrix, avgValue);
    }

    public double getCrossEntropy(Matrix matrix1, Matrix matrix2) throws Exception {
        double sigMod = 0.0;
        int x = matrix1.getX();
        int y = matrix1.getY();
        if (x == matrix2.getX() && y == matrix2.getY()) {
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    sigMod += matrix2.getNumber(i, j) * Math.log(matrix1.getNumber(i, j));
                }
            }
            return -sigMod;
        }
        throw new Exception("matrix is not equals");
    }

    public Matrix softMaxByMatrix(Matrix feature) throws Exception {
        int j;
        int i;
        double sigma = 0.0;
        int x = feature.getX();
        int y = feature.getY();
        Matrix softMaxMatrix = new Matrix(x, y);
        for (i = 0; i < x; ++i) {
            for (j = 0; j < y; ++j) {
                double value = feature.getNumber(i, j);
                sigma = Math.exp(value) + sigma;
            }
        }
        for (i = 0; i < x; ++i) {
            for (j = 0; j < y; ++j) {
                double eSelf = Math.exp(feature.getNumber(i, j));
                double value = eSelf / sigma;
                softMaxMatrix.setNub(i, j, value);
            }
        }
        return softMaxMatrix;
    }

    public Matrix sub(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix1.getY());
            int x = matrix1.getX();
            int y = matrix1.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) - matrix2.getNumber(i, j));
                }
            }
            return matrix;
        }
        throw new Exception("matrix is not equals");
    }

    public Matrix getLinearRegression(Matrix parameter, Matrix out) throws Exception {
        if (parameter.getX() == out.getX() && out.isVector()) {
            Matrix matrix1 = this.transPosition(parameter);
            Matrix matrix2 = this.mulMatrix(matrix1, parameter);
            Matrix matrix3 = this.getInverseMatrix(matrix2);
            if (matrix3.getX() == 1 && matrix3.getY() == 1) {
                return matrix3;
            }
            Matrix matrix4 = this.mulMatrix(matrix3, matrix1);
            return this.mulMatrix(matrix4, out);
        }
        throw new Exception("invalid regression matrix");
    }

    public double getEDistByMatrix(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            int x = matrix1.getX();
            int y = matrix1.getY();
            double sigma = 0.0;
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    double sub = matrix1.getNumber(i, j) - matrix2.getNumber(i, j);
                    sigma += Math.pow(sub, 2.0);
                }
            }
            return sigma / (double)(x * y);
        }
        throw new Exception("two matrixes is not equals");
    }

    public double getEDist(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.isRowVector() && matrix2.isRowVector() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = this.sub(matrix1, matrix2);
            return this.getNorm(matrix);
        }
        throw new Exception("this matrix is not  rowVector or length different");
    }

    public double errorNub(Matrix matrix, Matrix avgMatrix) throws Exception {
        int y = matrix.getY();
        if (matrix.isRowVector() && avgMatrix.isRowVector() && y == avgMatrix.getY()) {
            double[] subAll = new double[y];
            for (int j = 0; j < y; ++j) {
                double sub;
                double mySelf = matrix.getNumber(0, j);
                double avg = avgMatrix.getNumber(0, j);
                subAll[j] = sub = Math.pow(avg - mySelf, 2.0);
            }
            double sigma = 0.0;
            for (int i = 0; i < y; ++i) {
                sigma += subAll[i];
            }
            return sigma / (double)y;
        }
        throw new Exception("this matrix is not  rowVector or length different");
    }

    public Matrix pushVector(Matrix myMatrix, Matrix matrix, boolean addRow) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix addMatrix;
            if (addRow) {
                if (matrix.getY() != myMatrix.getY()) {
                    throw new Exception("this matrix column is not equals");
                }
                addMatrix = new Matrix(myMatrix.getX() + 1, myMatrix.getY());
            } else {
                if (matrix.getX() != myMatrix.getX()) {
                    throw new Exception("this matrix row is not equals");
                }
                addMatrix = new Matrix(myMatrix.getX(), myMatrix.getY() + 1);
            }
            for (int i = 0; i < addMatrix.getX(); ++i) {
                for (int j = 0; j < addMatrix.getY(); ++j) {
                    if (addRow) {
                        if (i == addMatrix.getX() - 1) {
                            addMatrix.setNub(i, j, matrix.getNumber(0, j));
                            continue;
                        }
                        addMatrix.setNub(i, j, myMatrix.getNumber(i, j));
                        continue;
                    }
                    if (j == addMatrix.getY() - 1) {
                        addMatrix.setNub(i, j, matrix.getNumber(i, 0));
                        continue;
                    }
                    addMatrix.setNub(i, j, myMatrix.getNumber(i, j));
                }
            }
            return addMatrix;
        }
        throw new Exception("this matrix is not a vector");
    }

    public Matrix push(Matrix matrix, double nub, boolean isRow) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix myMatrix;
            int nubs;
            if (isRow) {
                nubs = matrix.getY() + 1;
                myMatrix = new Matrix(1, nubs);
            } else {
                nubs = matrix.getX() + 1;
                myMatrix = new Matrix(nubs, 1);
            }
            for (int i = 0; i < nubs; ++i) {
                if (i == nubs - 1) {
                    if (isRow) {
                        myMatrix.setNub(0, i, nub);
                        continue;
                    }
                    myMatrix.setNub(i, 0, nub);
                    continue;
                }
                if (isRow) {
                    myMatrix.setNub(0, i, matrix.getNumber(0, i));
                    continue;
                }
                myMatrix.setNub(i, 0, matrix.getNumber(i, 0));
            }
            return myMatrix;
        }
        throw new Exception("this matrix is not a vector");
    }

    public Matrix getPoolVector(Matrix matrix) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix vector;
            int nub;
            boolean isRow = false;
            if (matrix.getX() == 1) {
                isRow = true;
                nub = matrix.getY() / 4;
                vector = new Matrix(1, nub);
            } else {
                nub = matrix.getX() / 4;
                vector = new Matrix(nub, 1);
            }
            int k = 0;
            for (int i = 0; i < nub * 4 - 3; i += 4) {
                double max = 0.0;
                if (isRow) {
                    max = matrix.getNumber(0, i);
                    max = this.getMax(max, matrix.getNumber(0, i + 1));
                    max = this.getMax(max, matrix.getNumber(0, i + 2));
                    max = this.getMax(max, matrix.getNumber(0, i + 3));
                    vector.setNub(0, k, max);
                } else {
                    max = matrix.getNumber(i, 0);
                    max = this.getMax(max, matrix.getNumber(i + 1, 0));
                    max = this.getMax(max, matrix.getNumber(i + 2, 0));
                    max = this.getMax(max, matrix.getNumber(i + 3, 0));
                    vector.setNub(k, 0, max);
                }
                ++k;
            }
            return vector;
        }
        throw new Exception("this matrix is not a vector");
    }

    private double getMax(double o1, double o2) {
        return Math.max(o1, o2);
    }

    public Matrix matrixToVector(Matrix matrix, boolean isRow) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix myMatrix = isRow ? new Matrix(1, x * y) : new Matrix(x * y, 1);
        int t = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (isRow) {
                    myMatrix.setNub(0, t, matrix.getNumber(i, j));
                } else {
                    myMatrix.setNub(t, 0, matrix.getNumber(i, j));
                }
                ++t;
            }
        }
        return myMatrix;
    }

    public double innerProduct(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            double sigma = 0.0;
            for (int i = 0; i < matrix1.getX(); ++i) {
                for (int j = 0; j < matrix1.getY(); ++j) {
                    sigma += matrix1.getNumber(i, j) * matrix2.getNumber(i, j);
                }
            }
            return sigma;
        }
        throw new Exception("\u4e24\u4e2a\u5411\u91cf\u7684\u957f\u5bbd\u5fc5\u987b\u76f8\u540c");
    }

    public double getNorm(Matrix matrix) throws Exception {
        if (matrix.getY() == 1 || matrix.getX() == 1) {
            double nub = 0.0;
            for (int i = 0; i < matrix.getX(); ++i) {
                for (int j = 0; j < matrix.getY(); ++j) {
                    nub = Math.pow(matrix.getNumber(i, j), 2.0) + nub;
                }
            }
            return Math.sqrt(nub);
        }
        throw new Exception("this matrix is not vector");
    }

    public double getNormCos(Matrix matrix1, Matrix matrix2) throws Exception {
        double inner = this.innerProduct(matrix1, matrix2);
        double mulNorm = this.getNorm(matrix1) * this.getNorm(matrix2);
        return inner / mulNorm;
    }

    public Matrix transPosition(Matrix matrix) throws Exception {
        Matrix myMatrix = new Matrix(matrix.getY(), matrix.getX());
        for (int i = 0; i < matrix.getY(); ++i) {
            Matrix matrixColumn = matrix.getColumn(i);
            for (int j = 0; j < matrixColumn.getX(); ++j) {
                double myNode = matrixColumn.getNumber(j, 0);
                myMatrix.setNub(i, j, myNode);
            }
        }
        return myMatrix;
    }

    public double convolution(Matrix matrix, Matrix kernel, int x, int y) throws Exception {
        double allNub = 0.0;
        int xr = 0;
        int yr = 0;
        int kxMax = kernel.getX();
        int kyMax = kernel.getY();
        for (int i = 0; i < kxMax; ++i) {
            xr = i + x;
            for (int j = 0; j < kyMax; ++j) {
                yr = j + y;
                allNub = matrix.getNumber(xr, yr) * kernel.getNumber(i, j) + allNub;
            }
        }
        return allNub;
    }

    public double getKernelNub(Matrix matrix, Matrix kernel) throws Exception {
        double allNub = 0.0;
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                allNub = matrix.getNumber(i, j) * kernel.getNumber(i, j) + allNub;
            }
        }
        return allNub;
    }

    public int inverseNumber(double[] myInverse) {
        int size = myInverse.length;
        int inverserNumber = 0;
        for (int i = 0; i < size; ++i) {
            double element = myInverse[i];
            for (int j = i + 1; j < size; ++j) {
                if (!(myInverse[j] < element)) continue;
                ++inverserNumber;
            }
        }
        return inverserNumber;
    }

    public Matrix getInverseMatrix(Matrix matrix) throws Exception {
        double def = matrix.getDet();
        if (def != 0.0) {
            def = 1.0 / def;
            Matrix myMatrix = this.adjointMatrix(matrix);
            this.mathMul(myMatrix, def);
            return myMatrix;
        }
        return new Matrix(1, 1);
    }

    public Matrix adjointMatrix(Matrix matrix) throws Exception {
        Matrix myMatrix = new Matrix(matrix.getX(), matrix.getY());
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                myMatrix.setNub(i, j, this.algebraicCofactor(matrix, i, j));
            }
        }
        return this.transPosition(myMatrix);
    }

    public double algebraicCofactor(Matrix matrix, int row, int column) throws Exception {
        if (row >= 0 && column >= 0 && row < matrix.getX() && column < matrix.getY()) {
            int x = matrix.getX() - 1;
            int y = matrix.getY() - 1;
            int ij = row + column + 2;
            int oldX = 0;
            int oldY = 0;
            boolean isXNext = false;
            Matrix myMatrix = new Matrix(x, y);
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    if (i == row && !isXNext) {
                        isXNext = true;
                        ++oldX;
                    }
                    if (j == column) {
                        ++oldY;
                    }
                    myMatrix.setNub(i, j, matrix.getNumber(oldX, oldY));
                    ++oldY;
                }
                ++oldX;
                oldY = 0;
            }
            double dm = myMatrix.getDet();
            if (ij % 2 != 0) {
                dm = -dm;
            }
            return dm;
        }
        throw new Exception("row or column index Beyond the limit");
    }

    public Matrix matrixPointDiv(Matrix matrix1, Matrix matrix2) throws Exception {
        int x = matrix1.getX();
        int y = matrix1.getY();
        Matrix matrix = new Matrix(x, y);
        if (matrix2.getX() == x && matrix2.getY() == y) {
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) / matrix2.getNumber(i, j));
                }
            }
        } else {
            throw new Exception("two matrix is not equals");
        }
        return matrix;
    }

    public Matrix matrixMulPd(Matrix errorMatrix, Matrix first, Matrix second, boolean isFirstPd) throws Exception {
        Matrix matrix = isFirstPd ? this.mulMatrix(errorMatrix, this.transPosition(second)) : this.mulMatrix(this.transPosition(first), errorMatrix);
        return matrix;
    }

    public double getSdByMatrix(Matrix m, double avg, double e) throws Exception {
        double var = 0.0;
        double size = m.getX() * m.getY();
        for (int i = 0; i < m.getX(); ++i) {
            for (int j = 0; j < m.getY(); ++j) {
                var += Math.pow(m.getNumber(i, j) - avg, 2.0);
            }
        }
        return Math.sqrt(var / size + e);
    }

    private Matrix mulMatrixOne(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getY() == matrix2.getX()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix2.getY());
            for (int i = 0; i < matrix1.getX(); ++i) {
                Matrix matrixRow = matrix1.getRow(i);
                for (int j = 0; j < matrix2.getY(); ++j) {
                    Matrix matrixColumn = matrix2.getColumn(j);
                    double columnAllNumber = 0.0;
                    for (int h = 0; h < matrixColumn.getX(); ++h) {
                        double columnNumber = matrixColumn.getNumber(h, 0);
                        double rowNumber = matrixRow.getNumber(0, h);
                        double nowNumber = columnNumber * rowNumber;
                        columnAllNumber += nowNumber;
                    }
                    matrix.setNub(i, j, columnAllNumber);
                }
            }
            return matrix;
        }
        throw new Exception("row is not equals column");
    }

    private Matrix mulMatrixMany(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getY() == matrix2.getX()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix2.getY());
            CountDownLatch countDownLatch = new CountDownLatch(matrix1.getX() * matrix2.getY());
            int x = matrix1.getX();
            int y = matrix2.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    MatrixMulAccelerate matrixMulAccelerate = new MatrixMulAccelerate(matrix1, matrix2, matrix, i, j, countDownLatch);
                    this.POOL.execute(matrixMulAccelerate);
                }
            }
            countDownLatch.await();
            return matrix;
        }
        throw new Exception("row is not equals column");
    }

    public Matrix mulMatrix(Matrix matrix1, Matrix matrix2) throws Exception {
        if (this.coreNumber > 1) {
            return this.mulMatrixMany(matrix1, matrix2);
        }
        return this.mulMatrixOne(matrix1, matrix2);
    }

    public Matrix mathMulBySelf(Matrix matrix, double nub) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix myMatrix = new Matrix(x, y);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                myMatrix.setNub(i, j, matrix.getNumber(i, j) * nub);
            }
        }
        return myMatrix;
    }

    public void mathMul(Matrix matrix, double nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) * nub);
            }
        }
    }

    public void mathAdd(Matrix matrix, double nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) + nub);
            }
        }
    }

    public void mathSub(Matrix matrix, double nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) - nub);
            }
        }
    }

    public void mathDiv(Matrix matrix, double nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) / nub);
            }
        }
    }

    public List<Double> matrixToList(Matrix matrix) throws Exception {
        ArrayList<Double> list = new ArrayList<Double>();
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                list.add(matrix.getNumber(i, j));
            }
        }
        return list;
    }

    public Matrix ListToMatrix(List<Double> list, int matrixX, int matrixY) throws Exception {
        Matrix matrix = new Matrix(matrixX, matrixY);
        for (int i = 0; i < matrixX; ++i) {
            for (int j = 0; j < matrixY; ++j) {
                int index = i * matrixY + j;
                matrix.setNub(i, j, list.get(index));
            }
        }
        return matrix;
    }

    public Matrix listToRowVector(List<Double> list) throws Exception {
        Matrix matrix = new Matrix(1, list.size());
        for (int i = 0; i < list.size(); ++i) {
            matrix.setNub(0, i, list.get(i));
        }
        return matrix;
    }

    public Matrix listToRowVector(List<Double> list, int nub) throws Exception {
        Matrix matrix = new Matrix(1, nub);
        for (int i = 0; i < nub; ++i) {
            double n = 0.0;
            if (list.size() > i) {
                n = list.get(i);
            }
            matrix.setNub(0, i, n);
        }
        return matrix;
    }

    private void inputVector(Matrix matrix, Matrix feature, int index, int kenLen) throws Exception {
        int y = matrix.getY();
        for (int i = 0; i < y - 1; ++i) {
            matrix.setNub(index, i, feature.getNumber(i / kenLen, i % kenLen));
        }
    }

    public Matrix im2col(Matrix matrix, int kernLen, int step) throws Exception {
        int ySize = kernLen * kernLen;
        int x = matrix.getX();
        int y = matrix.getY();
        int xSize = (x - (kernLen - step)) / step * ((y - (kernLen - step)) / step);
        Matrix myMatrix = new Matrix(xSize, ySize);
        int index = 0;
        for (int i = 0; i <= x - kernLen; i += step) {
            for (int j = 0; j <= y - kernLen; j += step) {
                this.inputVector(myMatrix, matrix.getSonOfMatrix(i, j, kernLen, kernLen), index, kernLen);
                ++index;
            }
        }
        return myMatrix;
    }

    public Matrix reverseIm2col(Matrix matrix, int kernLen, int step, int xSize, int ySize) throws Exception {
        int col = matrix.getY();
        int row = matrix.getX();
        int sub = kernLen - step;
        int y = (ySize - sub) / step;
        Matrix myMatrix = new Matrix(xSize, ySize);
        for (int i = 0; i < row; ++i) {
            int xz = i / y * step;
            int yz = i % y * step;
            for (int j = 0; j < col; ++j) {
                int xr = j / kernLen + xz;
                int yr = j % kernLen + yz;
                double value = myMatrix.getNumber(xr, yr) + matrix.getNumber(i, j);
                myMatrix.setNub(xr, yr, value);
            }
        }
        return myMatrix;
    }
}

