/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.nerveCenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.i.ActiveFunction;
import org.dromara.matrixTools.Matrix;
import org.dromara.nerveCenter.ModelParameter;
import org.dromara.nerveEntity.DymNerveStudy;
import org.dromara.nerveEntity.HiddenNerve;
import org.dromara.nerveEntity.Nerve;
import org.dromara.nerveEntity.NerveStudy;
import org.dromara.nerveEntity.OutNerve;
import org.dromara.nerveEntity.SensoryNerve;
import org.dromara.nerveEntity.SoftMax;

public class NerveManager {
    private final int hiddenNerveNub;
    private int sensoryNerveNub;
    private final int outNerveNub;
    private final int hiddenDepth;
    private final List<SensoryNerve> sensoryNerves = new ArrayList<SensoryNerve>();
    private final List<List<Nerve>> depthNerves = new ArrayList<List<Nerve>>();
    private final List<List<Nerve>> convDepthNerves = new ArrayList<List<Nerve>>();
    private final List<Nerve> outNerves = new ArrayList<Nerve>();
    private final List<Nerve> softMaxList = new ArrayList<Nerve>();
    private boolean initPower;
    private double studyPoint = 0.1;
    private double convStudyPoint = 0.1;
    private final ActiveFunction activeFunction;
    private final int rzType;
    private final double lParam;
    private final int coreNumber;

    private Map<String, Double> conversion(Map<Integer, Double> map) {
        HashMap<String, Double> cMap = new HashMap<String, Double>();
        for (Map.Entry<Integer, Double> entry : map.entrySet()) {
            cMap.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private Map<Integer, Double> unConversion(Map<String, Double> map) {
        HashMap<Integer, Double> cMap = new HashMap<Integer, Double>();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            cMap.put(Integer.parseInt(entry.getKey()), entry.getValue());
        }
        return cMap;
    }

    private ModelParameter getDymModelParameter() throws Exception {
        ModelParameter modelParameter = new ModelParameter();
        ArrayList<List<DymNerveStudy>> convStudies = new ArrayList<List<DymNerveStudy>>();
        modelParameter.setDymNerveStudies(convStudies);
        for (List<Nerve> convDepthNerve : this.convDepthNerves) {
            ArrayList<DymNerveStudy> dymNerveStudies = new ArrayList<DymNerveStudy>();
            for (Nerve depthNerve : convDepthNerve) {
                DymNerveStudy deepNerveStudy = new DymNerveStudy();
                List<Double> list = deepNerveStudy.getList();
                Matrix matrix = depthNerve.getNerveMatrix();
                this.insertWList(matrix, list);
                dymNerveStudies.add(deepNerveStudy);
            }
            convStudies.add(dymNerveStudies);
        }
        this.getStaticModelParameter(modelParameter);
        return modelParameter;
    }

    private void insertWList(Matrix matrix, List<Double> list) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                list.add(matrix.getNumber(i, j));
            }
        }
    }

    public ModelParameter getConvModel() throws Exception {
        return this.getDymModelParameter();
    }

    public ModelParameter getDnnModel() throws Exception {
        ModelParameter modelParameter = new ModelParameter();
        this.getStaticModelParameter(modelParameter);
        return modelParameter;
    }

    private void getStaticModelParameter(ModelParameter modelParameter) {
        ArrayList<List<NerveStudy>> studyDepthNerves = new ArrayList<List<NerveStudy>>();
        ArrayList<NerveStudy> outStudyNerves = new ArrayList<NerveStudy>();
        for (List<Nerve> depthNerve : this.depthNerves) {
            ArrayList<NerveStudy> deepNerve = new ArrayList<NerveStudy>();
            for (Nerve nerve : depthNerve) {
                NerveStudy nerveStudy = new NerveStudy();
                nerveStudy.setThreshold(nerve.getThreshold());
                nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
                deepNerve.add(nerveStudy);
            }
            studyDepthNerves.add(deepNerve);
        }
        for (Nerve nerve : this.outNerves) {
            NerveStudy nerveStudy = new NerveStudy();
            nerveStudy.setThreshold(nerve.getThreshold());
            nerveStudy.setDendrites(this.conversion(nerve.getDendrites()));
            outStudyNerves.add(nerveStudy);
        }
        modelParameter.setDepthNerves(studyDepthNerves);
        modelParameter.setOutNerves(outStudyNerves);
    }

    public void insertConvModel(ModelParameter modelParameter) throws Exception {
        this.insertConvolutionModelParameter(modelParameter);
    }

    public void insertDnnModel(ModelParameter modelParameter) {
        this.insertBpModelParameter(modelParameter);
    }

    private void insertConvolutionModelParameter(ModelParameter modelParameter) throws Exception {
        List<List<DymNerveStudy>> allDymNerveStudyList = modelParameter.getDymNerveStudies();
        for (int t = 0; t < allDymNerveStudyList.size(); ++t) {
            List<DymNerveStudy> dymNerveStudyList = allDymNerveStudyList.get(t);
            for (int i = 0; i < dymNerveStudyList.size(); ++i) {
                Nerve depthNerve = this.convDepthNerves.get(t).get(i);
                DymNerveStudy dymNerveStudy = dymNerveStudyList.get(i);
                List<Double> list = dymNerveStudy.getList();
                Matrix nerveMatrix = depthNerve.getNerveMatrix();
                this.insertMatrix(nerveMatrix, list);
            }
        }
        this.insertBpModelParameter(modelParameter);
    }

    private void insertMatrix(Matrix matrix, List<Double> list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            matrix.setNub(i, 0, list.get(i));
        }
    }

    private void insertBpModelParameter(ModelParameter modelParameter) {
        int i;
        List<List<NerveStudy>> depthStudyNerves = modelParameter.getDepthNerves();
        List<NerveStudy> outStudyNerves = modelParameter.getOutNerves();
        for (i = 0; i < this.depthNerves.size(); ++i) {
            List<NerveStudy> depth = depthStudyNerves.get(i);
            List<Nerve> depthNerve = this.depthNerves.get(i);
            for (int j = 0; j < depthNerve.size(); ++j) {
                Nerve nerve = depthNerve.get(j);
                NerveStudy nerveStudy = depth.get(j);
                Map<Integer, Double> studyDendrites = this.unConversion(nerveStudy.getDendrites());
                Map<Integer, Double> dendrites = nerve.getDendrites();
                nerve.setThreshold(nerveStudy.getThreshold());
                for (Map.Entry<Integer, Double> entry : dendrites.entrySet()) {
                    int key = entry.getKey();
                    dendrites.put(key, studyDendrites.get(key));
                }
            }
        }
        for (i = 0; i < this.outNerves.size(); ++i) {
            Nerve outNerve = this.outNerves.get(i);
            NerveStudy nerveStudy = outStudyNerves.get(i);
            outNerve.setThreshold(nerveStudy.getThreshold());
            Map<Integer, Double> dendrites = outNerve.getDendrites();
            Map<Integer, Double> studyDendrites = this.unConversion(nerveStudy.getDendrites());
            for (Map.Entry<Integer, Double> outEntry : dendrites.entrySet()) {
                int key = outEntry.getKey();
                dendrites.put(key, studyDendrites.get(key));
            }
        }
    }

    public NerveManager(int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int hiddenDepth, ActiveFunction activeFunction, double studyPoint, int rzType, double lParam, int coreNumber) throws Exception {
        if (sensoryNerveNub > 0 && hiddenNerveNub > 0 && outNerveNub > 0 && hiddenDepth > 0 && activeFunction != null) {
            this.coreNumber = coreNumber;
            this.hiddenNerveNub = hiddenNerveNub;
            this.sensoryNerveNub = sensoryNerveNub;
            this.outNerveNub = outNerveNub;
            this.hiddenDepth = hiddenDepth;
            this.activeFunction = activeFunction;
            this.rzType = rzType;
            this.lParam = lParam;
            if (studyPoint > 0.0 && studyPoint < 1.0) {
                this.studyPoint = studyPoint;
            }
        } else {
            throw new Exception("param is null");
        }
    }

    public List<SensoryNerve> getSensoryNerves() {
        return this.sensoryNerves;
    }

    private List<Nerve> initConDepthNerve(int step, int kernLen, int conHiddenDepth, ActiveFunction convFunction, int id) throws Exception {
        int i;
        ArrayList<Nerve> depthNerves = new ArrayList<Nerve>();
        for (i = 0; i < conHiddenDepth; ++i) {
            double studyPoint = this.convStudyPoint;
            if (studyPoint <= 0.0 || studyPoint > 1.0) {
                throw new Exception("studyPoint Values range from 0 to 1");
            }
            int downNub = 1;
            boolean isConvFinish = false;
            if (i == conHiddenDepth - 1) {
                downNub = this.hiddenNerveNub;
                isConvFinish = true;
            }
            HiddenNerve hiddenNerve = new HiddenNerve(id, i + 1, 1, downNub, studyPoint, this.initPower, convFunction, true, this.rzType, this.lParam, step, kernLen, 0, 0, isConvFinish, this.coreNumber);
            depthNerves.add(hiddenNerve);
        }
        for (i = 0; i < conHiddenDepth - 1; ++i) {
            Nerve hiddenNerve = (Nerve)depthNerves.get(i);
            Nerve nextHiddenNerve = (Nerve)depthNerves.get(i + 1);
            ArrayList<Nerve> hiddenNerveList = new ArrayList<Nerve>();
            ArrayList<Nerve> nextHiddenNerveList = new ArrayList<Nerve>();
            hiddenNerveList.add(hiddenNerve);
            nextHiddenNerveList.add(nextHiddenNerve);
            hiddenNerve.connect(nextHiddenNerveList);
            nextHiddenNerve.connectFather(hiddenNerveList);
        }
        return depthNerves;
    }

    private int getConvMyDep(int xSize, int ySize, int step, int kernLen) {
        int xDeep = this.getConvDeep(xSize, step, kernLen);
        int yDeep = this.getConvDeep(ySize, step, kernLen);
        return Math.min(xDeep, yDeep);
    }

    private int getConvDeep(int size, int step, int kernLen) {
        int y;
        int x = size;
        int deep = 0;
        do {
            x = y = (x - (kernLen - step)) / step;
            ++deep;
        } while (y >= kernLen);
        return deep;
    }

    private int getNerveNub(int deep, int size, int kernLen, int step) {
        int x = size;
        for (int i = 0; i < deep; ++i) {
            x = (x - (kernLen - step)) / step;
        }
        return x;
    }

    public void initImageNet(int step, int kernLen, int xSize, int ySize, boolean isSoftMax, boolean isShowLog, double convStudyPoint, ActiveFunction convFunction) throws Exception {
        this.initPower = true;
        this.convStudyPoint = convStudyPoint;
        int deep = this.getConvMyDep(xSize, ySize, step, kernLen);
        ArrayList<Nerve> lastNerves = new ArrayList<Nerve>();
        this.sensoryNerveNub = 3;
        for (int i = 0; i < this.sensoryNerveNub; ++i) {
            List<Nerve> depthNerves = this.initConDepthNerve(step, kernLen, deep, convFunction, i + 1);
            this.convDepthNerves.add(depthNerves);
            Iterator<Nerve> firstDepthNerves = new ArrayList<Nerve>();
            firstDepthNerves.add(depthNerves.get(0));
            SensoryNerve sensoryNerve = new SensoryNerve(i + 1, 0);
            sensoryNerve.connect((List<Nerve>)((Object)firstDepthNerves));
            this.sensoryNerves.add(sensoryNerve);
            lastNerves.add(depthNerves.get(depthNerves.size() - 1));
        }
        this.initDepthNerve(step, kernLen, this.getNerveNub(deep, xSize, kernLen, step), this.getNerveNub(deep, ySize, kernLen, step));
        List<Nerve> firstNerves = this.depthNerves.get(0);
        List<Nerve> lastNerveList = this.depthNerves.get(this.depthNerves.size() - 1);
        for (Nerve nerve : lastNerves) {
            nerve.connect(firstNerves);
        }
        for (Nerve nerve : firstNerves) {
            nerve.connectFather(lastNerves);
        }
        ArrayList<OutNerve> myOutNerveList = new ArrayList<OutNerve>();
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.hiddenNerveNub, 0, this.studyPoint, this.initPower, this.activeFunction, false, isShowLog, this.rzType, this.lParam, isSoftMax, 0, 0, this.coreNumber);
            outNerve.connectFather(lastNerveList);
            this.outNerves.add(outNerve);
            myOutNerveList.add(outNerve);
        }
        if (isSoftMax) {
            SoftMax softMax = new SoftMax(this.outNerveNub, false, myOutNerveList, isShowLog, this.coreNumber);
            this.softMaxList.add(softMax);
            for (Nerve nerve : this.outNerves) {
                nerve.connect(this.softMaxList);
            }
        }
        for (Nerve nerve : lastNerveList) {
            nerve.connect(this.outNerves);
        }
    }

    public void init(boolean initPower, boolean isShowLog, boolean isSoftMax) throws Exception {
        this.initPower = initPower;
        this.initDepthNerve(0, 0, 0, 0);
        List<Nerve> nerveList = this.depthNerves.get(0);
        List<Nerve> lastNerveList = this.depthNerves.get(this.depthNerves.size() - 1);
        ArrayList<OutNerve> myOutNerveList = new ArrayList<OutNerve>();
        for (int i = 1; i < this.outNerveNub + 1; ++i) {
            OutNerve outNerve = new OutNerve(i, this.hiddenNerveNub, 0, this.studyPoint, initPower, this.activeFunction, false, isShowLog, this.rzType, this.lParam, isSoftMax, 0, 0, this.coreNumber);
            outNerve.connectFather(lastNerveList);
            this.outNerves.add(outNerve);
            myOutNerveList.add(outNerve);
        }
        if (isSoftMax) {
            SoftMax softMax = new SoftMax(this.outNerveNub, false, myOutNerveList, isShowLog, this.coreNumber);
            this.softMaxList.add(softMax);
            for (Nerve nerve : this.outNerves) {
                nerve.connect(this.softMaxList);
            }
        }
        for (Nerve nerve : lastNerveList) {
            nerve.connect(this.outNerves);
        }
        for (int i = 1; i < this.sensoryNerveNub + 1; ++i) {
            SensoryNerve sensoryNerve = new SensoryNerve(i, 0);
            sensoryNerve.connect(nerveList);
            this.sensoryNerves.add(sensoryNerve);
        }
    }

    private void initDepthNerve(int step, int kernLen, int matrixX, int matrixY) throws Exception {
        for (int i = 0; i < this.hiddenDepth; ++i) {
            ArrayList<HiddenNerve> hiddenNerveList = new ArrayList<HiddenNerve>();
            double studyPoint = this.studyPoint;
            if (studyPoint <= 0.0 || studyPoint > 1.0) {
                throw new Exception("studyPoint Values range from 0 to 1");
            }
            for (int j = 1; j < this.hiddenNerveNub + 1; ++j) {
                int upNub;
                int myMatrixX = 0;
                int myMatrixY = 0;
                if (i == 0) {
                    myMatrixX = matrixX;
                    myMatrixY = matrixY;
                    upNub = matrixX > 0 && matrixY > 0 ? this.sensoryNerveNub * matrixX * matrixY : this.sensoryNerveNub;
                } else {
                    upNub = this.hiddenNerveNub;
                }
                int downNub = i == this.hiddenDepth - 1 ? this.outNerveNub : this.hiddenNerveNub;
                HiddenNerve hiddenNerve = new HiddenNerve(j, i + 1, upNub, downNub, studyPoint, this.initPower, this.activeFunction, false, this.rzType, this.lParam, step, kernLen, myMatrixX, myMatrixY, false, this.coreNumber);
                hiddenNerveList.add(hiddenNerve);
            }
            this.depthNerves.add(hiddenNerveList);
        }
        this.initHiddenNerve();
    }

    private void initHiddenNerve() {
        for (int i = 0; i < this.hiddenDepth - 1; ++i) {
            List<Nerve> hiddenNerveList = this.depthNerves.get(i);
            List<Nerve> nextHiddenNerveList = this.depthNerves.get(i + 1);
            for (Nerve hiddenNerve : hiddenNerveList) {
                hiddenNerve.connect(nextHiddenNerveList);
            }
            for (Nerve nextHiddenNerve : nextHiddenNerveList) {
                nextHiddenNerve.connectFather(hiddenNerveList);
            }
        }
    }
}

