/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.nerveEntity;

import java.util.List;
import java.util.Map;
import org.dromara.i.ActiveFunction;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixOperation;
import org.dromara.nerveEntity.Nerve;

public class HiddenNerve
extends Nerve {
    private final boolean isConvFinish;
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public HiddenNerve(int id, int depth, int upNub, int downNub, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int matrixX, int matrixY, boolean isConvFinish, int coreNumber) throws Exception {
        super(id, upNub, "HiddenNerve", downNub, studyPoint, init, activeFunction, isDynamic, rzType, lParam, step, kernLen, depth, matrixX, matrixY, coreNumber);
        this.isConvFinish = isConvFinish;
    }

    @Override
    public void input(long eventId, double parameter, boolean isKernelStudy, Map<Integer, Double> E, OutBack outBack) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            double out = this.activeFunction.function(sigma);
            if (isKernelStudy) {
                this.outNub = out;
            } else {
                this.destoryParameter(eventId);
            }
            this.sendMessage(eventId, out, isKernelStudy, E, outBack);
        }
    }

    @Override
    protected void inputMatrixFeature(long eventId, List<Double> parameters, boolean isStudy, Map<Integer, Double> E, OutBack imageBack) throws Exception {
        boolean allReady = this.insertParameters(eventId, parameters);
        if (allReady) {
            double sigma = this.calculation(eventId);
            double out = this.activeFunction.function(sigma);
            if (isStudy) {
                this.outNub = out;
            } else {
                this.destoryParameter(eventId);
            }
            this.sendMessage(eventId, out, isStudy, E, imageBack);
        }
    }

    @Override
    protected void inputMatrix(long eventId, Matrix matrix, boolean isStudy, Map<Integer, Double> E, OutBack outBack, boolean needMatrix) throws Exception {
        Matrix myMatrix = this.conv(matrix);
        if (this.isConvFinish) {
            if (!isStudy && needMatrix) {
                outBack.getBackMatrix(myMatrix, this.getId(), eventId);
            }
            this.sendMatrixList(eventId, this.matrixOperation.matrixToList(myMatrix), isStudy, E, outBack);
        } else {
            this.sendMatrix(eventId, myMatrix, isStudy, E, outBack, needMatrix);
        }
    }
}

