/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.nerveEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.i.ActiveFunction;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixOperation;

public abstract class Nerve {
    private final List<Nerve> son = new ArrayList<Nerve>();
    private final List<Nerve> father = new ArrayList<Nerve>();
    protected Map<Integer, Double> dendrites = new HashMap<Integer, Double>();
    protected Map<Integer, Double> wg = new HashMap<Integer, Double>();
    private final int id;
    protected int upNub;
    protected int downNub;
    protected Map<Long, List<Double>> features = new HashMap<Long, List<Double>>();
    protected Matrix nerveMatrix;
    protected double threshold;
    protected String name;
    protected double outNub;
    protected double E;
    protected double gradient;
    protected double studyPoint;
    protected double sigmaW;
    protected Matrix sigmaMatrix;
    private int backNub = 0;
    protected ActiveFunction activeFunction;
    private final int rzType;
    private final double lParam;
    private final int step;
    private final int kernLen;
    private Matrix im2col;
    private int xInput;
    private int yInput;
    private Matrix outMatrix;
    protected final int depth;
    protected final int matrixX;
    protected final int matrixY;
    private final MatrixOperation matrixOperation;

    public Map<Integer, Double> getDendrites() {
        return this.dendrites;
    }

    public Matrix getNerveMatrix() {
        return this.nerveMatrix;
    }

    public void setNerveMatrix(Matrix nerveMatrix) {
        this.nerveMatrix = nerveMatrix;
    }

    public void setDendrites(Map<Integer, Double> dendrites) {
        this.dendrites = dendrites;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    protected Nerve(int id, int upNub, String name, int downNub, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, int rzType, double lParam, int step, int kernLen, int depth, int matrixX, int matrixY, int coreNumber) throws Exception {
        this.matrixOperation = new MatrixOperation(coreNumber);
        this.matrixX = matrixX;
        this.matrixY = matrixY;
        this.id = id;
        this.depth = depth;
        this.upNub = upNub;
        this.name = name;
        this.downNub = downNub;
        this.studyPoint = studyPoint;
        this.activeFunction = activeFunction;
        this.rzType = rzType;
        this.lParam = lParam;
        this.step = step;
        this.kernLen = kernLen;
        this.initPower(init, isDynamic);
    }

    protected void setStudyPoint(double studyPoint) {
        this.studyPoint = studyPoint;
    }

    public void sendMessage(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack) throws Exception {
        if (!this.son.isEmpty()) {
            for (Nerve nerve : this.son) {
                nerve.input(eventId, parameter, isStudy, E, outBack);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    protected Matrix conv(Matrix matrix) throws Exception {
        this.xInput = matrix.getX();
        this.yInput = matrix.getY();
        int sub = this.kernLen - this.step;
        int x = (this.xInput - sub) / this.step;
        int y = (this.yInput - sub) / this.step;
        Matrix myMatrix = new Matrix(x, y);
        this.im2col = this.matrixOperation.im2col(matrix, this.kernLen, this.step);
        Matrix matrixOut = this.matrixOperation.mulMatrix(this.im2col, this.nerveMatrix);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                double nub = this.activeFunction.function(matrixOut.getNumber(i * y + j, 0));
                myMatrix.setNub(i, j, nub);
            }
        }
        this.outMatrix = myMatrix;
        return myMatrix;
    }

    public void sendMatrixList(long eventId, List<Double> parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack) throws Exception {
        if (!this.son.isEmpty()) {
            for (Nerve nerve : this.son) {
                nerve.inputMatrixFeature(eventId, parameter, isStudy, E, outBack);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    public void sendMatrix(long eventId, Matrix parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, boolean needMatrix) throws Exception {
        if (!this.son.isEmpty()) {
            for (Nerve nerve : this.son) {
                nerve.inputMatrix(eventId, parameter, isStudy, E, outBack, needMatrix);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    private void backSendMessage(long eventId) throws Exception {
        block5: {
            if (this.father.isEmpty()) break block5;
            if (this.depth == 1) {
                int size = this.matrixX * this.matrixY;
                for (int i = 0; i < this.father.size(); ++i) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    int startIndex = size * i;
                    int endIndex = startIndex + size;
                    for (int j = startIndex; j < endIndex; ++j) {
                        list.add(this.wg.get(j + 1));
                    }
                    Matrix errorMatrix = this.matrixOperation.ListToMatrix(list, this.matrixX, this.matrixY);
                    this.father.get(i).backMatrix(errorMatrix);
                }
            } else {
                for (int i = 0; i < this.father.size(); ++i) {
                    this.father.get(i).backGetMessage(this.wg.get(i + 1), eventId);
                }
            }
        }
    }

    private void backMatrixMessage(Matrix g) throws Exception {
        if (!this.father.isEmpty()) {
            for (Nerve nerve : this.father) {
                nerve.backMatrix(g);
            }
        }
    }

    protected void input(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack imageBack) throws Exception {
    }

    protected void inputMatrixFeature(long eventId, List<Double> parameters, boolean isStudy, Map<Integer, Double> E, OutBack imageBack) throws Exception {
    }

    protected void inputMatrix(long eventId, Matrix matrix, boolean isKernelStudy, Map<Integer, Double> E, OutBack outBack, boolean needMatrix) throws Exception {
    }

    private void backGetMessage(double parameter, long eventId) throws Exception {
        ++this.backNub;
        this.sigmaW += parameter;
        if (this.backNub == this.downNub) {
            this.backNub = 0;
            this.gradient = this.activeFunction.functionG(this.outNub) * this.sigmaW;
            this.updatePower(eventId);
        }
    }

    protected void backMatrix(Matrix t) throws Exception {
        ++this.backNub;
        this.sigmaMatrix = this.sigmaMatrix == null ? t : this.matrixOperation.add(t, this.sigmaMatrix);
        if (this.backNub == this.downNub) {
            this.backNub = 0;
            int x = this.sigmaMatrix.getX();
            int y = this.sigmaMatrix.getY();
            Matrix yc = new Matrix(x * y, 1);
            int index = 0;
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    double error = this.sigmaMatrix.getNumber(i, j);
                    double out = this.outMatrix.getNumber(i, j);
                    error = error * this.activeFunction.functionG(out) * this.studyPoint;
                    yc.setNub(index, 0, error);
                    ++index;
                }
            }
            Matrix trx = this.matrixOperation.transPosition(this.im2col);
            Matrix wSub = this.matrixOperation.mulMatrix(trx, yc);
            x = this.im2col.getX();
            y = this.im2col.getY();
            for (int i = 0; i < x; ++i) {
                double ySub = yc.getNumber(i, 0);
                for (int j = 0; j < y; ++j) {
                    double k = this.nerveMatrix.getNumber(j, 0) * ySub;
                    this.im2col.setNub(i, j, k);
                }
            }
            Matrix gNext = this.matrixOperation.reverseIm2col(this.im2col, this.kernLen, this.step, this.xInput, this.yInput);
            this.nerveMatrix = this.matrixOperation.add(this.nerveMatrix, wSub);
            this.sigmaMatrix = null;
            this.backMatrixMessage(gNext);
        }
    }

    protected void updatePower(long eventId) throws Exception {
        double h = this.gradient * this.studyPoint;
        this.threshold -= h;
        this.updateW(h, eventId);
        this.sigmaW = 0.0;
        this.backSendMessage(eventId);
    }

    private double regularization(double w, double param) {
        double re = 0.0;
        if (this.rzType != 0) {
            if (this.rzType == 2) {
                re = param * -w;
            } else if (this.rzType == 1) {
                if (w > 0.0) {
                    re = -param;
                } else if (w < 0.0) {
                    re = param;
                }
            }
        }
        return re;
    }

    private void updateW(double h, long eventId) {
        List<Double> list = this.features.get(eventId);
        double param = 0.0;
        if (this.rzType != 0) {
            double sigma = 0.0;
            for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
                if (this.rzType == 2) {
                    sigma += Math.pow(entry.getValue(), 2.0);
                    continue;
                }
                sigma += Math.abs(entry.getValue());
            }
            param = sigma * this.lParam * this.studyPoint;
        }
        for (Map.Entry<Integer, Double> entry : this.dendrites.entrySet()) {
            int key = entry.getKey();
            double w = entry.getValue();
            double bn = list.get(key - 1);
            double wp = bn * h;
            double dm = w * this.gradient;
            double regular = this.regularization(w, param);
            w += regular;
            this.wg.put(key, dm);
            this.dendrites.put(key, w += wp);
        }
        this.features.remove(eventId);
    }

    protected boolean insertParameters(long eventId, List<Double> parameters) {
        List<Object> featuresList;
        boolean allReady = false;
        if (this.features.containsKey(eventId)) {
            featuresList = this.features.get(eventId);
        } else {
            featuresList = new ArrayList();
            this.features.put(eventId, featuresList);
        }
        featuresList.addAll(parameters);
        if (featuresList.size() >= this.upNub) {
            allReady = true;
        }
        return allReady;
    }

    protected boolean insertParameter(long eventId, double parameter) {
        List<Object> featuresList;
        boolean allReady = false;
        if (this.features.containsKey(eventId)) {
            featuresList = this.features.get(eventId);
        } else {
            featuresList = new ArrayList();
            this.features.put(eventId, featuresList);
        }
        featuresList.add(parameter);
        if (featuresList.size() >= this.upNub) {
            allReady = true;
        }
        return allReady;
    }

    protected void destoryParameter(long eventId) {
        this.features.remove(eventId);
    }

    protected double calculation(long eventId) throws Exception {
        double sigma = 0.0;
        List<Double> featuresList = this.features.get(eventId);
        if (this.dendrites.size() != featuresList.size()) {
            throw new Exception("\u6743\u91cd\u6570\u91cf:" + this.dendrites.size() + ",\u7279\u5f81\u6570\u91cf:" + featuresList.size());
        }
        for (int i = 0; i < featuresList.size(); ++i) {
            double value = featuresList.get(i);
            double w = this.dendrites.get(i + 1);
            sigma = w * value + sigma;
        }
        return sigma - this.threshold;
    }

    private void initPower(boolean init, boolean isDynamic) throws Exception {
        Random random = new Random();
        if (!isDynamic) {
            if (this.upNub > 0) {
                for (int i = 1; i < this.upNub + 1; ++i) {
                    double nub = 0.0;
                    if (init) {
                        nub = random.nextDouble() / Math.sqrt(this.upNub);
                    }
                    this.dendrites.put(i, nub);
                }
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() / Math.sqrt(this.upNub);
                }
                this.threshold = nub;
            }
        } else {
            int nerveNub = this.kernLen * this.kernLen;
            this.nerveMatrix = new Matrix(nerveNub, 1);
            for (int i = 0; i < this.nerveMatrix.getX(); ++i) {
                double nub = 0.0;
                if (init) {
                    nub = random.nextDouble() / (double)this.kernLen;
                }
                this.nerveMatrix.setNub(i, 0, nub);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void connect(List<Nerve> nerveList) {
        this.son.addAll(nerveList);
    }

    public void connectFather(List<Nerve> nerveList) {
        this.father.addAll(nerveList);
    }
}

