/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.nerveEntity;

import java.util.Map;
import org.dromara.i.ActiveFunction;
import org.dromara.i.OutBack;
import org.dromara.nerveEntity.Nerve;

public class OutNerve
extends Nerve {
    private final boolean isShowLog;
    private final boolean isSoftMax;

    public OutNerve(int id, int upNub, int downNub, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, boolean isShowLog, int rzType, double lParam, boolean isSoftMax, int step, int kernLen, int coreNumber) throws Exception {
        super(id, upNub, "OutNerve", downNub, studyPoint, init, activeFunction, isDynamic, rzType, lParam, step, kernLen, 0, 0, 0, coreNumber);
        this.isShowLog = isShowLog;
        this.isSoftMax = isSoftMax;
    }

    void getGBySoftMax(double g, long eventId) throws Exception {
        this.gradient = g;
        this.updatePower(eventId);
    }

    @Override
    public void input(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            if (this.isSoftMax) {
                if (!isStudy) {
                    this.destoryParameter(eventId);
                }
                this.sendMessage(eventId, sigma, isStudy, E, outBack);
            } else {
                double out = this.activeFunction.function(sigma);
                if (isStudy) {
                    this.outNub = out;
                    this.E = E.containsKey(this.getId()) ? E.get(this.getId()) : -1.0;
                    if (this.isShowLog) {
                        System.out.println("E==" + this.E + ",out==" + out + ",nerveId==" + this.getId());
                    }
                    this.gradient = this.outGradient();
                    this.updatePower(eventId);
                } else {
                    this.destoryParameter(eventId);
                    if (outBack != null) {
                        outBack.getBack(out, this.getId(), eventId);
                    } else {
                        throw new Exception("not find outBack");
                    }
                }
            }
        }
    }

    private double outGradient() {
        return this.activeFunction.functionG(this.outNub) * (this.E - this.outNub);
    }
}

