/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.recommend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dromara.function.Tanh;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.recommend.CodeBack;
import org.dromara.recommend.CodeBody;
import org.dromara.recommend.RecommendConfig;
import org.dromara.rnnNerveCenter.NerveManager;
import org.dromara.rnnNerveEntity.SensoryNerve;
import org.dromara.tools.IdCreator;

public class RecommendCodeManager {
    private final NerveManager nerveManager;
    private final double studyTh;
    private final int dim;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RecommendCodeManager(boolean initPower, RecommendConfig recommendConfig) throws Exception {
        this.studyTh = recommendConfig.getStudyTh();
        this.dim = recommendConfig.getDimension();
        this.nerveManager = new NerveManager(31, this.dim, 31, 1, new Tanh(), false, 0.01, 1, 0.002);
        this.nerveManager.setSoftMax(false);
        this.nerveManager.initRnn(initPower, false);
    }

    public double[] getFeatures(int feature) {
        double[] features = new double[31];
        for (int i = 0; i < 31; ++i) {
            int t = 1 << i;
            if ((feature & t) == 0) continue;
            features[i] = 1.0;
        }
        return features;
    }

    public Map<Integer, Double> getMap(double[] feature) {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i = 0; i < feature.length; ++i) {
            int t = i + 1;
            map.put(t, feature[i]);
        }
        return map;
    }

    private Matrix getSubMatrix(double sub) throws Exception {
        Matrix subMatrix = new Matrix(2, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            subMatrix.setNub(1, i, sub);
        }
        return subMatrix;
    }

    public void study(List<CodeBody> codeBodyList) throws Exception {
        for (int i = 0; i < codeBodyList.size(); ++i) {
            CodeBody myCodeBody = codeBodyList.get(i);
            double myPower = myCodeBody.getPower();
            if (!(myPower >= this.studyTh)) continue;
            double[] myId = this.getFeatures(myCodeBody.getId());
            Map<Integer, Double> myMapId = this.getMap(myId);
            for (int j = 0; j < codeBodyList.size(); ++j) {
                if (i == j) continue;
                CodeBody codeBody = codeBodyList.get(j);
                Matrix sub = this.getSubMatrix((myPower - codeBody.getPower()) / (double)this.dim);
                double[] id = this.getFeatures(codeBody.getId());
                Map<Integer, Double> mapId = this.getMap(id);
                this.lock.writeLock().lock();
                this.studyNerve(1L, myId, sub, mapId, true, null);
                this.studyNerve(1L, id, sub, myMapId, true, null);
                this.lock.writeLock().unlock();
            }
        }
    }

    public double[] getMappingId(int id) throws Exception {
        this.lock.readLock().lock();
        CodeBack codeBack = new CodeBack();
        codeBack.setMyFeature(new double[31]);
        Matrix subMatrix = new Matrix(2, this.dim);
        long nextId = IdCreator.get().nextId();
        double[] feature = this.getFeatures(id);
        this.studyNerve(nextId, feature, subMatrix, null, false, codeBack);
        this.lock.readLock().unlock();
        return codeBack.getMyFeature();
    }

    private void studyNerve(long eventId, double[] features, Matrix rnnMatrix, Map<Integer, Double> E, boolean isStudy, OutBack convBack) throws Exception {
        List<SensoryNerve> sensoryNerves = this.nerveManager.getSensoryNerves();
        if (sensoryNerves.size() == features.length) {
            for (int i = 0; i < sensoryNerves.size(); ++i) {
                sensoryNerves.get(i).postMessage(eventId, features[i], isStudy, E, convBack, false, rnnMatrix);
            }
        } else {
            throw new Exception("size not equals,feature size:" + features.length + ",sensorySize:" + sensoryNerves.size());
        }
    }
}

