/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.regressionForest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixOperation;
import org.dromara.regressionForest.Forest;
import org.dromara.tools.Frequency;

public class RegressionForest
extends Frequency {
    private double[] w;
    private Matrix conditionMatrix;
    private Matrix resultMatrix;
    private Forest forest;
    private int featureNub;
    private int xIndex = 0;
    private double[] results;
    private double min;
    private double max;
    private Matrix pc;
    private int cosSize = 20;
    private TreeMap<Integer, Forest> forestMap = new TreeMap();
    private final MatrixOperation matrixOperation = new MatrixOperation();

    public int getCosSize() {
        return this.cosSize;
    }

    public void setCosSize(int cosSize) {
        this.cosSize = cosSize;
    }

    public RegressionForest(int size, int featureNub, double shrinkParameter, int minGrain) throws Exception {
        if (size <= 0 || featureNub <= 0) {
            throw new Exception("size and featureNub too small");
        }
        this.featureNub = featureNub;
        this.w = new double[featureNub];
        this.results = new double[size];
        this.conditionMatrix = new Matrix(size, featureNub);
        this.resultMatrix = new Matrix(size, 1);
        this.createG();
        this.forest = new Forest(featureNub, shrinkParameter, this.pc, this.forestMap, 1, minGrain);
        this.forestMap.put(1, this.forest);
        this.forest.setW(this.w);
        this.forest.setConditionMatrix(this.conditionMatrix);
        this.forest.setResultMatrix(this.resultMatrix);
    }

    public double getDist(Matrix featureMatrix, double result) throws Exception {
        Forest forestFinish = this.getRegion(this.forest, featureMatrix);
        double[] w = forestFinish.getW();
        double sigma = 0.0;
        for (int i = 0; i < w.length; ++i) {
            double nub = i < w.length - 1 ? w[i] * featureMatrix.getNumber(0, i) : w[i];
            sigma += nub;
        }
        return Math.abs(result - sigma);
    }

    private Forest getRegion(Forest forest, Matrix matrix) throws Exception {
        double median = forest.getMedian();
        double result = forest.getMappingFeature(matrix);
        if (result > median && forest.getForestRight() != null) {
            forest = forest.getForestRight();
        } else if (result <= median && forest.getForestLeft() != null) {
            forest = forest.getForestLeft();
        } else {
            return forest;
        }
        return this.getRegion(forest, matrix);
    }

    private Forest getLimitRegion(Forest forest, boolean isMax) {
        Forest forestSon = isMax ? forest.getForestRight() : forest.getForestLeft();
        if (forestSon != null) {
            return this.getLimitRegion(forestSon, isMax);
        }
        return forest;
    }

    private void createG() throws Exception {
        double[] cg = new double[this.featureNub - 1];
        Random random = new Random();
        double sigma = 0.0;
        for (int i = 0; i < this.featureNub - 1; ++i) {
            double rm;
            cg[i] = rm = random.nextDouble();
            sigma += Math.pow(rm, 2.0);
        }
        double cosOne = 1.0 / (double)this.cosSize;
        double[] ag = new double[this.cosSize - 1];
        for (int i = 0; i < this.cosSize - 1; ++i) {
            double cos = cosOne * (double)(i + 1);
            ag[i] = Math.sqrt(sigma / (1.0 / Math.pow(cos, 2.0) - 1.0));
        }
        int x = (this.cosSize - 1) * this.featureNub;
        this.pc = new Matrix(x, this.featureNub);
        for (int i = 0; i < this.featureNub; ++i) {
            Matrix matrix = new Matrix(ag.length, this.featureNub);
            for (int j = 0; j < ag.length; ++j) {
                for (int k = 0; k < this.featureNub; ++k) {
                    if (k != i) {
                        if (k < i) {
                            matrix.setNub(j, k, cg[k]);
                            continue;
                        }
                        matrix.setNub(j, k, cg[k - 1]);
                        continue;
                    }
                    matrix.setNub(j, k, ag[j]);
                }
            }
            int index = (this.cosSize - 1) * i;
            this.push(this.pc, matrix, index);
        }
    }

    private void push(Matrix mother, Matrix son, int index) throws Exception {
        if (mother.getY() == son.getY()) {
            int x = index + son.getX();
            int y = mother.getY();
            int start = 0;
            for (int i = index; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    mother.setNub(i, j, son.getNumber(start, j));
                }
                ++start;
            }
        } else {
            throw new Exception("matrix Y is not equals");
        }
    }

    public void insertFeature(double[] feature, double result) throws Exception {
        if (feature.length == this.featureNub - 1) {
            for (int i = 0; i < this.featureNub; ++i) {
                if (i < this.featureNub - 1) {
                    this.conditionMatrix.setNub(this.xIndex, i, feature[i]);
                    continue;
                }
                this.results[this.xIndex] = result;
                this.conditionMatrix.setNub(this.xIndex, i, 1.0);
                this.resultMatrix.setNub(this.xIndex, 0, result);
            }
            ++this.xIndex;
        } else {
            throw new Exception("feature length is not equals");
        }
    }

    public void startStudy() throws Exception {
        if (this.forest == null) {
            throw new Exception("rootForest is null");
        }
        this.forest.setResultVariance(this.variance(this.results));
        double[] limit = this.getLimit(this.results);
        this.min = limit[0];
        this.max = limit[1];
        this.start(this.forest);
        this.regression();
        this.pruning();
    }

    private void start(Forest forest) throws Exception {
        forest.cut();
        Forest forestLeft = forest.getForestLeft();
        Forest forestRight = forest.getForestRight();
        if (forestLeft != null && forestRight != null) {
            this.start(forestLeft);
            this.start(forestRight);
        }
    }

    private void pruning() {
        int max = this.forestMap.lastKey();
        int layersNub = (int)(Math.log(max) / Math.log(2.0));
        int lastMin = (int)Math.pow(2.0, layersNub);
        if (layersNub > 1) {
            for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
                if (entry.getKey() < lastMin) continue;
                Forest forest = entry.getValue();
                forest.pruning();
            }
        }
        block1: for (int i = layersNub - 1; i > 0; --i) {
            int min = (int)Math.pow(2.0, i);
            int maxNub = (int)Math.pow(2.0, i + 1);
            for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
                int key = entry.getKey();
                if (key >= min && key < maxNub) {
                    entry.getValue().pruning();
                    continue;
                }
                if (key < maxNub) continue;
                continue block1;
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, Forest> entry : this.forestMap.entrySet()) {
            int key = entry.getKey();
            Forest forest = entry.getValue();
            if (!forest.isRemove()) continue;
            list.add(key);
        }
        Iterator<Map.Entry<Integer, Forest>> iterator = list.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)((Object)iterator.next());
            this.forestMap.remove(key);
        }
    }

    private void regression() throws Exception {
        if (this.forest == null) {
            throw new Exception("rootForest is null");
        }
        this.regressionTree(this.forest);
    }

    private void regressionTree(Forest forest) throws Exception {
        this.regression(forest);
        Forest forestLeft = forest.getForestLeft();
        Forest forestRight = forest.getForestRight();
        if (forestLeft != null && forestRight != null) {
            this.regressionTree(forestLeft);
            this.regressionTree(forestRight);
        }
    }

    private void regression(Forest forest) throws Exception {
        Matrix conditionMatrix = forest.getConditionMatrix();
        Matrix resultMatrix = forest.getResultMatrix();
        Matrix ws = this.matrixOperation.getLinearRegression(conditionMatrix, resultMatrix);
        double[] w = forest.getW();
        for (int i = 0; i < ws.getX(); ++i) {
            w[i] = ws.getNumber(i, 0);
        }
    }
}

