/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.rnnJumpNerveCenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.config.SentenceConfig;
import org.dromara.entity.TypeMapping;
import org.dromara.entity.WordBack;
import org.dromara.function.Tanh;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.naturalLanguage.word.WordEmbedding;
import org.dromara.rnnJumpNerveCenter.NerveJumpManager;
import org.dromara.rnnJumpNerveCenter.RandomModel;
import org.dromara.rnnJumpNerveEntity.MyWordFeature;
import org.dromara.rnnJumpNerveEntity.SensoryNerve;

public class RRNerveManager {
    private final WordEmbedding wordEmbedding;
    private final Map<Integer, Integer> mapping = new HashMap<Integer, Integer>();
    private NerveJumpManager typeNerveManager;
    private int typeNub;
    private int vectorDimension;
    private int maxFeatureLength;
    private double studyPoint;
    private boolean showLog;
    private int minLength;
    private double trustPowerTh = 0.0;
    private int rzModel;
    private double rzParam;

    public RRNerveManager(WordEmbedding wordEmbedding) {
        this.wordEmbedding = wordEmbedding;
    }

    public void init(SentenceConfig config) throws Exception {
        if (config.getTypeNub() <= 0) {
            throw new Exception("\u5206\u7c7b\u79cd\u7c7b\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        this.trustPowerTh = config.getTrustPowerTh();
        this.minLength = config.getMinLength();
        this.typeNub = config.getTypeNub();
        this.vectorDimension = config.getWordVectorDimension();
        this.maxFeatureLength = config.getMaxWordLength();
        this.studyPoint = config.getWeStudyPoint();
        this.showLog = config.isShowLog();
        this.rzModel = config.getRzModel();
        this.rzParam = config.getParam();
        this.initNerveManager();
    }

    private void initNerveManager() throws Exception {
        this.typeNerveManager = new NerveJumpManager(this.vectorDimension, this.vectorDimension, this.typeNub, this.maxFeatureLength - 1, new Tanh(), false, this.studyPoint, this.rzModel, this.rzParam);
        this.typeNerveManager.initRnn(true, this.showLog, true, false, 0);
    }

    private int getMappingType(int key) {
        int id = 0;
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            if (entry.getValue() != key) continue;
            id = entry.getKey();
            break;
        }
        return id;
    }

    private int balance(Map<Integer, List<String>> model) {
        int maxNumber = 300;
        int index = 1;
        for (Map.Entry<Integer, List<String>> entry : model.entrySet()) {
            this.mapping.put(entry.getKey(), index);
            if (entry.getValue().size() > maxNumber) {
                maxNumber = entry.getValue().size();
            }
            ++index;
        }
        for (Map.Entry<Integer, List<String>> entry : model.entrySet()) {
            int size = entry.getValue().size();
            if (maxNumber <= size) continue;
            int times = maxNumber / size - 1;
            int sub = maxNumber % size;
            List<String> list = entry.getValue();
            ArrayList<String> otherList = new ArrayList<String>(list);
            for (int i = 0; i < times; ++i) {
                list.addAll(otherList);
            }
            list.addAll(otherList.subList(0, sub));
        }
        return maxNumber;
    }

    private void studyNerve(long eventId, List<SensoryNerve> sensoryNerves, List<Double> featureList, Matrix rnnMatrix, Map<Integer, Double> E, boolean isStudy, OutBack convBack, int[] storeys) throws Exception {
        if (sensoryNerves.size() == featureList.size()) {
            for (int i = 0; i < sensoryNerves.size(); ++i) {
                sensoryNerves.get(i).postMessage(eventId, featureList.get(i), isStudy, E, convBack, rnnMatrix, storeys, 0);
            }
        } else {
            throw new Exception("1size not equals,feature size:" + featureList.size() + ",sensorySize:" + sensoryNerves.size());
        }
    }

    public int getType(String sentence, long eventID) throws Exception {
        if (sentence.length() > this.maxFeatureLength) {
            sentence = sentence.substring(0, this.maxFeatureLength);
        }
        MyWordFeature myWordFeature = this.wordEmbedding.getEmbedding(sentence, eventID, false);
        List<Double> featureList = myWordFeature.getFirstFeatureList();
        Matrix featureMatrix = myWordFeature.getFeatureMatrix();
        int[] storeys = new int[featureMatrix.getX()];
        for (int i = 0; i < storeys.length; ++i) {
            storeys[i] = i;
        }
        WordBack wordBack = new WordBack();
        this.studyNerve(eventID, this.typeNerveManager.getSensoryNerves(), featureList, featureMatrix, null, false, wordBack, storeys);
        if (wordBack.getOut() > this.trustPowerTh) {
            return this.getMappingType(wordBack.getId());
        }
        return -1;
    }

    public void insertModel(RandomModel randomModel) throws Exception {
        this.typeNerveManager.insertModelParameter(randomModel.getTypeModelParameter());
        List<TypeMapping> typeMappings = randomModel.getTypeMappings();
        this.mapping.clear();
        for (TypeMapping typeMapping : typeMappings) {
            this.mapping.put(typeMapping.getType(), typeMapping.getMapping());
        }
    }

    public RandomModel getModel() throws Exception {
        RandomModel randomModel = new RandomModel();
        randomModel.setTypeModelParameter(this.typeNerveManager.getModelParameter());
        ArrayList<TypeMapping> typeMappings = new ArrayList<TypeMapping>();
        randomModel.setTypeMappings(typeMappings);
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            TypeMapping typeMapping = new TypeMapping();
            typeMapping.setType(entry.getKey());
            typeMapping.setMapping(entry.getValue());
            typeMappings.add(typeMapping);
        }
        return randomModel;
    }

    public RandomModel studyType(Map<Integer, List<String>> model) throws Exception {
        int maxNumber = this.balance(model);
        for (int i = 0; i < this.maxFeatureLength; ++i) {
            System.out.println("1\u7b2c\uff1a" + (i + 1) + "\u6b21\u3002\u5171:" + this.maxFeatureLength + "\u6b21");
            this.myStudy(maxNumber, model, i + 1);
        }
        return this.getModel();
    }

    private void myStudy(int maxNumber, Map<Integer, List<String>> model, int time) throws Exception {
        int index = 0;
        HashMap<Integer, Double> E = new HashMap<Integer, Double>();
        do {
            for (Map.Entry<Integer, List<String>> entry : model.entrySet()) {
                System.out.println("index======" + index + "," + time + "\u6b21");
                E.clear();
                List<String> sentence = entry.getValue();
                int key = this.mapping.get(entry.getKey());
                E.put(key, 1.0);
                String word = sentence.get(index);
                if (word.length() > this.maxFeatureLength) {
                    word = word.substring(0, this.maxFeatureLength);
                }
                this.randomTypeStudy(this.wordEmbedding.getEmbedding(word, 1L, false), E);
            }
        } while (++index < maxNumber);
    }

    private void randomTypeStudy(MyWordFeature myWordFeature, Map<Integer, Double> E) throws Exception {
        Matrix featureMatrix = myWordFeature.getFeatureMatrix();
        List<Double> firstFeatureList = myWordFeature.getFirstFeatureList();
        int len = featureMatrix.getX();
        Random random = new Random();
        if (len > 1) {
            int[] storeys;
            if (len < this.minLength) {
                storeys = new int[len];
                for (int i = 0; i < len; ++i) {
                    storeys[i] = i;
                }
            } else {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 1; i < len; ++i) {
                    list.add(i);
                }
                int myLen = (int)((double)this.minLength + Math.random() * (double)(len - this.minLength + 1));
                storeys = new int[myLen];
                for (int i = 1; i < myLen; ++i) {
                    int index = random.nextInt(list.size());
                    storeys[i] = (Integer)list.get(index);
                    list.remove(index);
                }
                Arrays.sort(storeys);
            }
            this.studyNerve(1L, this.typeNerveManager.getSensoryNerves(), firstFeatureList, featureMatrix, E, true, null, storeys);
        }
    }
}

