/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.rnnJumpNerveEntity;

import java.util.Map;
import org.dromara.i.ActiveFunction;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.rnnJumpNerveEntity.Nerve;

public class OutNerve
extends Nerve {
    private Map<Integer, Matrix> matrixMapE;
    private final boolean isShowLog;
    private final boolean isSoftMax;

    public OutNerve(int id, double studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, boolean isShowLog, int rzType, double lParam, boolean isSoftMax, int step, int kernLen, int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int allDepth) throws Exception {
        super(id, "OutNerve", studyPoint, init, activeFunction, isDynamic, rzType, lParam, step, kernLen, sensoryNerveNub, hiddenNerveNub, outNerveNub, allDepth, false, 0);
        this.isShowLog = isShowLog;
        this.isSoftMax = isSoftMax;
    }

    void getGBySoftMax(double g, long eventId, int[] storeys, int index) throws Exception {
        this.gradient = g;
        this.updatePower(eventId, storeys, index);
    }

    public void setMatrixMap(Map<Integer, Matrix> matrixMap) {
        this.matrixMapE = matrixMap;
    }

    @Override
    protected void sendAppointTestMessage(long eventId, double parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            this.destroyParameter(eventId);
            this.sendSoftMaxBack(eventId, sigma, featureMatrix, outBack, myWord);
        }
    }

    public void backMatrixError(double g, long eventId, int[] storeys, int index) throws Exception {
        this.gradient = this.activeFunction.functionG(this.outNub) * g;
        this.updatePower(eventId, storeys, index);
    }

    @Override
    public void input(long eventId, double parameter, boolean isStudy, Map<Integer, Double> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            double sigma = this.calculation(eventId);
            if (this.isSoftMax) {
                if (!isStudy) {
                    this.destroyParameter(eventId);
                }
                this.sendSoftMax(eventId, sigma, isStudy, E, outBack, rnnMatrix, storeys, index);
            } else {
                double out = this.activeFunction.function(sigma);
                if (isStudy) {
                    this.outNub = out;
                    this.E = E.containsKey(this.getId()) ? E.get(this.getId()) : 0.0;
                    if (this.isShowLog) {
                        System.out.println("E==" + this.E + ",out==" + out + ",nerveId==" + this.getId());
                    }
                    this.gradient = this.outGradient();
                    this.updatePower(eventId, storeys, index);
                } else {
                    this.destroyParameter(eventId);
                    if (outBack != null) {
                        outBack.getBack(out, this.getId(), eventId);
                    } else {
                        throw new Exception("not find outBack");
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void inputMatrix(long eventId, Matrix matrix, boolean isKernelStudy, int E, OutBack outBack) throws Exception {
        Matrix myMatrix = this.conv(matrix);
        if (isKernelStudy) {
            Matrix matrix1 = this.matrixMapE.get(E);
            if (this.isShowLog) {
                System.out.println("E========" + E);
                System.out.println(myMatrix.getString());
            }
            if (matrix1.getX() != myMatrix.getX() || matrix1.getY() != myMatrix.getY()) throw new Exception("Wrong size setting of image in templateConfig");
            Matrix g = this.getGradient(myMatrix, matrix1);
            this.backMatrix(g);
            return;
        } else {
            if (outBack == null) throw new Exception("not find outBack");
            outBack.getBackMatrix(myMatrix, this.getId(), eventId);
        }
    }

    private Matrix getGradient(Matrix matrix, Matrix E) throws Exception {
        Matrix matrix1 = new Matrix(matrix.getX(), matrix.getY());
        for (int i = 0; i < E.getX(); ++i) {
            for (int j = 0; j < E.getY(); ++j) {
                double nub = E.getNumber(i, j) - matrix.getNumber(i, j);
                matrix1.setNub(i, j, nub);
            }
        }
        return matrix1;
    }

    private double outGradient() {
        return this.activeFunction.functionG(this.outNub) * (this.E - this.outNub);
    }
}

