/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.tools;

import org.dromara.entity.ThreeChannelMatrix;
import org.dromara.matrixTools.Matrix;
import org.dromara.regressionForest.LinearRegression;

public class FastPictureExcerpt {
    public String creatImageName(ThreeChannelMatrix threeChannelMatrix, int boxSize, int regionSize) throws Exception {
        String R = this.creatImageName(threeChannelMatrix.getMatrixR(), boxSize, regionSize);
        String G = this.creatImageName(threeChannelMatrix.getMatrixG(), boxSize, regionSize);
        String B = this.creatImageName(threeChannelMatrix.getMatrixB(), boxSize, regionSize);
        return R + G + B;
    }

    private String creatImageName(Matrix h, int boxSize, int regionSize) throws Exception {
        int iSize = 5;
        Matrix vector = new Matrix(1, 3);
        vector.setNub(0, 0, 1.0);
        vector.setNub(0, 1, 0.0);
        vector.setNub(0, 2, 0.0);
        int xf = h.getX();
        int yf = h.getY();
        int xMO = xf % boxSize / 2;
        int yMO = yf % boxSize / 2;
        int xSize = xf / boxSize;
        int ySize = yf / boxSize;
        Matrix hr = h.getSonOfMatrix(xMO, yMO, xSize * boxSize, ySize * boxSize);
        int x = hr.getX();
        int y = hr.getY();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= x - xSize; i += xSize) {
            for (int j = 0; j <= y - ySize; j += ySize) {
                Matrix sonH = hr.getSonOfMatrix(i, j, xSize, ySize);
                String name = FastPictureExcerpt.getName(sonH, iSize, vector, regionSize);
                if (regionSize > 10 && regionSize <= 100) {
                    if (name.length() == 1) {
                        name = "0" + name;
                    }
                } else if (regionSize > 100 && regionSize <= 1000) {
                    if (name.length() == 1) {
                        name = "00" + name;
                    } else if (name.length() == 2) {
                        name = "0" + name;
                    }
                }
                stringBuilder.append(name);
            }
        }
        return stringBuilder.toString();
    }

    private static String getName(Matrix h, int iSize, Matrix vector, int regionSize) throws Exception {
        int x = h.getX();
        int y = h.getY();
        int size = x / iSize * (y / iSize);
        LinearRegression linearRegression = new LinearRegression(size);
        int cPoint = iSize / 2 + 1;
        double maxXSize = (double)x / (double)iSize;
        double maxYSize = (double)y / (double)iSize;
        double[] xy = new double[2];
        for (int i = 0; i <= x - iSize; i += iSize) {
            for (int j = 0; j <= y - iSize; j += iSize) {
                double value = h.getSonOfMatrix(i, j, iSize, iSize).getNumber(cPoint, cPoint);
                double px = (double)i / (double)iSize / maxXSize;
                double py = (double)j / (double)iSize / maxYSize;
                xy[0] = px;
                xy[1] = py;
                linearRegression.insertXY(xy, value);
            }
        }
        linearRegression.regression();
        double myCos = linearRegression.getCos(vector);
        double oneSize = 1.0 / (double)regionSize;
        int index = 0;
        double minSub = -1.0;
        for (int i = 0; i < regionSize; ++i) {
            double cos = Math.cos(Math.PI * oneSize * (double)i);
            double sub = Math.abs(cos - myCos);
            if (minSub != -1.0 && !(sub < minSub)) continue;
            minSub = sub;
            index = i;
        }
        return String.valueOf(index);
    }
}

