/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.tools;

import java.util.List;
import org.dromara.tools.ArithUtil;

public abstract class Frequency {
    public double average(double ... m) {
        int len = m.length;
        double allNub = 0.0;
        for (int i = 0; i < len; ++i) {
            allNub += m[i];
        }
        return allNub /= (double)len;
    }

    public static double getEDist(double[] x1, double[] x2) {
        double[] y = new double[x1.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x1[i] - x2[i];
        }
        double sigma = 0.0;
        for (int i = 0; i < y.length; ++i) {
            sigma += Math.pow(y[i], 2.0);
        }
        return Math.sqrt(sigma);
    }

    public double averageByList(List<Double> m) {
        int len = m.size();
        double allNub = 0.0;
        for (int i = 0; i < len; ++i) {
            allNub += m.get(i).doubleValue();
        }
        allNub = ArithUtil.div(allNub, len);
        return allNub;
    }

    public double sigma(double ... m) {
        int len = m.length;
        double allNub = 0.0;
        for (int i = 0; i < len; ++i) {
            allNub = ArithUtil.add(allNub, m[i]);
        }
        return allNub;
    }

    public double getPointLength(double x, double y, double i, double j) {
        return Math.sqrt(ArithUtil.add(Math.pow(ArithUtil.sub(x, i), 2.0), Math.pow(ArithUtil.sub(y, j), 2.0)));
    }

    public double variance(double ... m) {
        double ave = this.average(m);
        double allNub = 0.0;
        for (int i = 0; i < m.length; ++i) {
            allNub += Math.pow(m[i] - ave, 2.0);
        }
        return allNub / (double)m.length;
    }

    public double varianceByAve(double[] m, double ave) {
        double allNub = 0.0;
        for (int i = 0; i < m.length; ++i) {
            allNub += Math.pow(m[i] - ave, 2.0);
        }
        return allNub / (double)m.length;
    }

    public double sdByAvg(double[] m, double avg) {
        double var = this.varianceByAve(m, avg);
        return Math.sqrt(var);
    }

    public double sd(double ... m) {
        double var = this.variance(m);
        return Math.sqrt(var);
    }

    public double dcByAvg(double[] m, double ave) {
        double allNub = 0.0;
        for (int i = 0; i < m.length; ++i) {
            allNub += Math.pow(m[i] - ave, 2.0);
        }
        return ArithUtil.div(Math.sqrt(ArithUtil.div(allNub, m.length)), ave);
    }

    public double dc(double ... m) {
        double ave = this.average(m);
        double dc = 0.0;
        if (ave > 0.0) {
            double allNub = 0.0;
            for (int i = 0; i < m.length; ++i) {
                allNub += Math.pow(m[i] - ave, 2.0);
            }
            dc = ArithUtil.div(Math.sqrt(ArithUtil.div(allNub, m.length)), ave);
        }
        return dc;
    }

    public double softMax(int t, double ... m) {
        double my = Math.exp(m[t]);
        double all = 0.0;
        int allLength = m.length;
        for (int i = 0; i < allLength; ++i) {
            all += Math.exp(m[i]);
        }
        return ArithUtil.div(my, all);
    }

    public double[] getLimit(double[] m) {
        double[] limit = new double[2];
        double max = 0.0;
        double min = -1.0;
        for (double nub : m) {
            if (min == -1.0 || nub < min) {
                min = nub;
            }
            if (!(nub > max)) continue;
            max = nub;
        }
        limit[0] = min;
        limit[1] = max;
        return limit;
    }
}

