/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixOperation;

public class Knn
extends MatrixOperation {
    private Map<Integer, List<Matrix>> featureMap = new HashMap<Integer, List<Matrix>>();
    private int length;
    private final int nub;

    public Knn(int nub) {
        this.nub = nub;
    }

    public void setFeatureMap(Map<Integer, List<Matrix>> featureMap) {
        this.featureMap = featureMap;
    }

    public Map<Integer, List<Matrix>> getFeatureMap() {
        return this.featureMap;
    }

    public void removeType(int type) {
        this.featureMap.remove(type);
    }

    public void revoke(int type, int nub) {
        List<Matrix> list = this.featureMap.get(type);
        for (int i = 0; i < nub; ++i) {
            list.remove(list.size() - 1);
        }
    }

    public int getNub(int type) {
        int nub = 0;
        List<Matrix> list = this.featureMap.get(type);
        if (list != null) {
            nub = list.size();
        }
        return nub;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertMatrix(Matrix vector, int tag) throws Exception {
        if (!vector.isVector() || !vector.isRowVector()) throw new Exception("this matrix is not vector or rowVector");
        if (this.featureMap.size() == 0) {
            ArrayList<Matrix> list = new ArrayList<Matrix>();
            list.add(vector);
            this.featureMap.put(tag, list);
            this.length = vector.getY();
            return;
        } else {
            if (this.length != vector.getY()) throw new Exception("vector length is different");
            if (this.featureMap.containsKey(tag)) {
                this.featureMap.get(tag).add(vector);
                return;
            } else {
                ArrayList<Matrix> list = new ArrayList<Matrix>();
                list.add(vector);
                this.featureMap.put(tag, list);
            }
        }
    }

    private void compare(double[] values, int[] types, double value, int type) {
        for (int i = 0; i < values.length; ++i) {
            double val = values[i];
            if (val < 0.0) {
                values[i] = value;
                types[i] = type;
                break;
            }
            if (!(value < val)) continue;
            for (int j = values.length - 2; j >= i; --j) {
                values[j + 1] = values[j];
                types[j + 1] = types[j];
            }
            values[i] = value;
            types[i] = type;
            break;
        }
    }

    public int getType(Matrix vector) throws Exception {
        int type;
        int ty = 0;
        double[] dists = new double[this.nub];
        int[] types = new int[this.nub];
        for (int i = 0; i < this.nub; ++i) {
            dists[i] = -1.0;
        }
        for (Map.Entry<Integer, List<Matrix>> entry : this.featureMap.entrySet()) {
            type = entry.getKey();
            List<Matrix> matrices = entry.getValue();
            for (Matrix matrix : matrices) {
                double dist = this.getEDist(matrix, vector);
                this.compare(dists, types, dist, type);
            }
        }
        System.out.println(Arrays.toString(types));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.nub; ++i) {
            type = types[i];
            if (map.containsKey(type)) {
                map.put(type, (Integer)map.get(type) + 1);
                continue;
            }
            map.put(type, 1);
        }
        int max = 0;
        for (Map.Entry entry : map.entrySet()) {
            int value = (Integer)entry.getValue();
            int type2 = (Integer)entry.getKey();
            if (value <= max) continue;
            ty = type2;
            max = value;
        }
        return ty;
    }
}

