/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.tools;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dromara.entity.ThreeChannelMatrix;
import org.dromara.matrixTools.Matrix;

public class Picture {
    private int pictureWidth;
    private int pictureHeight;
    private boolean vertical = false;

    public void vertical() {
        this.vertical = true;
    }

    public Matrix getImageMatrixByLocal(String fileURL) throws Exception {
        File file = new File(fileURL);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getImage(bi);
    }

    public ThreeChannelMatrix getThreeMatrix(File file) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getThreeChannel(bi);
    }

    public ThreeChannelMatrix getThreeMatrix(InputStream file) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getThreeChannel(bi);
    }

    public ThreeChannelMatrix getThreeMatrix(String fileURL) throws Exception {
        File file = new File(fileURL);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getThreeChannel(bi);
    }

    public Matrix getImageMatrixByIo(InputStream inputStream) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getImage(bi);
    }

    private Matrix getImage(BufferedImage bi) throws Exception {
        int width = bi.getWidth();
        int height = bi.getHeight();
        this.pictureWidth = width;
        this.pictureHeight = height;
        Matrix matrix = new Matrix(height, width);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = bi.getRGB(j, i);
                double grab = this.dimensionReduction(pixel);
                matrix.setNub(i, j, grab);
            }
        }
        return matrix;
    }

    private ThreeChannelMatrix getThreeChannel(BufferedImage bi) throws Exception {
        int width = bi.getWidth();
        int height = bi.getHeight();
        boolean rotate = false;
        if (this.vertical && width > height) {
            rotate = true;
            width = bi.getHeight();
            height = bi.getWidth();
        }
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        threeChannelMatrix.setX(height);
        threeChannelMatrix.setY(width);
        Matrix matrixR = new Matrix(height, width);
        Matrix matrixG = new Matrix(height, width);
        Matrix matrixB = new Matrix(height, width);
        Matrix matrixH = new Matrix(height, width);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = rotate ? bi.getRGB(i, j) : bi.getRGB(j, i);
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                matrixR.setNub(i, j, (double)r / 255.0);
                matrixG.setNub(i, j, (double)g / 255.0);
                matrixB.setNub(i, j, (double)b / 255.0);
                matrixH.setNub(i, j, (double)(r * 38 + g * 75 + b * 15 >> 7) / 255.0);
            }
        }
        return threeChannelMatrix;
    }

    private double dimensionReduction(int pixel) {
        int r = (pixel & 0xFF0000) >> 16;
        int g = (pixel & 0xFF00) >> 8;
        int b = pixel & 0xFF;
        double gray = r * 38 + g * 75 + b * 15 >> 7;
        return gray;
    }

    public int getPictureWidth() {
        return this.pictureWidth;
    }

    public void setPictureWidth(int pictureWidth) {
        this.pictureWidth = pictureWidth;
    }

    public int getPictureHeight() {
        return this.pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        this.pictureHeight = pictureHeight;
    }
}

