/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.config.WaterConfig;
import org.dromara.entity.Box;
import org.dromara.entity.ThreeChannelMatrix;
import org.dromara.matrixTools.Matrix;
import org.dromara.tools.RegionBody;

public class Watershed {
    private final Matrix matrix;
    private final Matrix rainfallMap;
    private final Matrix regionMap;
    private final int xSize;
    private final int ySize;
    private final double rainTh;
    private final int regionNub;
    private final Map<Integer, RegionBody> regionBodyMap = new HashMap<Integer, RegionBody>();
    private final int xMax;
    private final int yMax;
    private final int cutMinXSize;
    private final int cutMinYSize;
    private final int cutMaxXSize;
    private final int cutMaxYSize;
    private final double high;
    private final Matrix matrixR;
    private final Matrix matrixG;
    private final Matrix matrixB;
    private final double myR;
    private final double myG;
    private final double myB;

    public Watershed(ThreeChannelMatrix matrix, WaterConfig config) throws Exception {
        if (matrix == null) {
            throw new Exception("matrix is null");
        }
        this.high = config.getHigh();
        this.cutMaxXSize = config.getCutMaxXSize();
        this.cutMaxYSize = config.getCutMaxYSize();
        this.cutMinXSize = config.getMinXSizeTh() + 2;
        this.cutMinYSize = config.getMinYSizeTh() + 2;
        this.myR = config.getMyR();
        this.myG = config.getMyG();
        this.myB = config.getMyB();
        this.rainTh = config.getRainTh();
        this.regionNub = config.getRegionNub();
        this.matrix = matrix.getH();
        this.matrixR = matrix.getMatrixR();
        this.matrixG = matrix.getMatrixG();
        this.matrixB = matrix.getMatrixB();
        this.xSize = this.matrix.getX() / this.regionNub;
        this.ySize = this.matrix.getY() / this.regionNub;
        this.rainfallMap = new Matrix(this.matrix.getX(), this.matrix.getY());
        this.regionMap = new Matrix(this.regionNub, this.regionNub);
        this.xMax = this.rainfallMap.getX() - 1;
        this.yMax = this.rainfallMap.getY() - 1;
    }

    private boolean backGround(int x, int y) throws Exception {
        double r = this.matrixR.getNumber(x, y);
        double g = this.matrixG.getNumber(x, y);
        double b = this.matrixB.getNumber(x, y);
        double dist = (Math.abs(r - this.myR) + Math.abs(g - this.myG) + Math.abs(b - this.myB)) / 3.0;
        return dist < this.high;
    }

    private double[] getPixels(int x, int y) throws Exception {
        double left = -1.0;
        double leftTop = -1.0;
        double leftBottom = -1.0;
        double right = -1.0;
        double rightTop = -1.0;
        double rightBottom = -1.0;
        double top = -1.0;
        double bottom = -1.0;
        if (x == 0) {
            top = 1.0;
            leftTop = 1.0;
            rightTop = 1.0;
        }
        if (y == 0) {
            leftTop = 1.0;
            left = 1.0;
            leftBottom = 1.0;
        }
        if (x == this.xMax) {
            leftBottom = 1.0;
            bottom = 1.0;
            rightBottom = 1.0;
        }
        if (y == this.yMax) {
            rightTop = 1.0;
            right = 1.0;
            rightBottom = 1.0;
        }
        if (top == -1.0 && this.rainfallMap.getNumber(x - 1, y) == 0.0) {
            top = this.backGround(x - 1, y) ? 1.0 : this.matrix.getNumber(x - 1, y);
        }
        if (left == -1.0 && this.rainfallMap.getNumber(x, y - 1) == 0.0) {
            left = this.backGround(x, y - 1) ? 1.0 : this.matrix.getNumber(x, y - 1);
        }
        if (bottom == -1.0 && this.rainfallMap.getNumber(x + 1, y) == 0.0) {
            bottom = this.backGround(x + 1, y) ? 1.0 : this.matrix.getNumber(x + 1, y);
        }
        if (right == -1.0 && this.rainfallMap.getNumber(x, y + 1) == 0.0) {
            right = this.backGround(x, y + 1) ? 1.0 : this.matrix.getNumber(x, y + 1);
        }
        if (leftTop == -1.0 && this.rainfallMap.getNumber(x - 1, y - 1) == 0.0) {
            leftTop = this.backGround(x - 1, y - 1) ? 1.0 : this.matrix.getNumber(x - 1, y - 1);
        }
        if (leftBottom == -1.0 && this.rainfallMap.getNumber(x + 1, y - 1) == 0.0) {
            leftBottom = this.backGround(x + 1, y - 1) ? 1.0 : this.matrix.getNumber(x + 1, y - 1);
        }
        if (rightTop == -1.0 && this.rainfallMap.getNumber(x - 1, y + 1) == 0.0) {
            rightTop = this.backGround(x - 1, y + 1) ? 1.0 : this.matrix.getNumber(x - 1, y + 1);
        }
        if (rightBottom == -1.0 && this.rainfallMap.getNumber(x + 1, y + 1) == 0.0) {
            rightBottom = this.backGround(x + 1, y + 1) ? 1.0 : this.matrix.getNumber(x + 1, y + 1);
        }
        return new double[]{top, left, bottom, right, leftTop, leftBottom, rightBottom, rightTop};
    }

    private int[] rain(int x, int y) throws Exception {
        double[] pixels = this.getPixels(x, y);
        int[] point = new int[8];
        double mySelf = this.matrix.getNumber(x, y);
        int index = this.getMinIndex(pixels, mySelf);
        if (index > 0) {
            for (int i = 0; i < 8; ++i) {
                int pixel;
                int t = index & 1 << i;
                if (t <= 0) continue;
                int row = x;
                int column = y;
                switch (i) {
                    case 0: {
                        row = x - 1;
                        break;
                    }
                    case 1: {
                        column = y - 1;
                        break;
                    }
                    case 2: {
                        row = x + 1;
                        break;
                    }
                    case 3: {
                        column = y + 1;
                        break;
                    }
                    case 4: {
                        column = y - 1;
                        row = x - 1;
                        break;
                    }
                    case 5: {
                        column = y - 1;
                        row = x + 1;
                        break;
                    }
                    case 6: {
                        column = y + 1;
                        row = x + 1;
                        break;
                    }
                    case 7: {
                        column = y + 1;
                        row = x - 1;
                    }
                }
                point[i] = pixel = row << 12 | column;
                this.rainfallMap.setNub(row, column, 1.0);
            }
        }
        return point;
    }

    private void pull(List<Integer> list, int[] points) {
        for (int point : points) {
            if (point == 0) continue;
            list.add(point);
        }
    }

    private void fall(int i, int j) throws Exception {
        ArrayList<Integer> list2;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(i << 12 | j);
        do {
            list2 = new ArrayList<Integer>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int pixel = (Integer)iterator.next();
                int x = pixel >> 12;
                int y = pixel & 0xFFF;
                int[] nodes = this.rain(x, y);
                this.pull(list2, nodes);
            }
        } while (!(list = list2).isEmpty());
    }

    public List<Box> rainfall() throws Exception {
        int x = this.matrix.getX();
        int y = this.matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (this.rainfallMap.getNumber(i, j) != 0.0) continue;
                this.fall(i, j);
            }
        }
        this.sigmaPixel();
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (Map.Entry<Integer, RegionBody> entry : this.regionBodyMap.entrySet()) {
            RegionBody regionBody = entry.getValue();
            int minX = regionBody.getMinX();
            int maxX = regionBody.getMaxX();
            int minY = regionBody.getMinY();
            int maxY = regionBody.getMaxY();
            int xSize = maxX - minX;
            int ySize = maxY - minY;
            if (xSize < this.cutMinXSize || ySize < this.cutMinYSize || xSize >= this.cutMaxXSize || ySize >= this.cutMaxYSize) continue;
            Box box = new Box();
            box.setX(minX);
            box.setY(minY);
            box.setRealX(minX + xSize / 2);
            box.setRealY(minY + ySize / 2);
            box.setxSize(xSize);
            box.setySize(ySize);
            boxes.add(box);
        }
        return boxes;
    }

    private void merge() throws Exception {
        int xSize = this.regionMap.getX();
        int ySize = this.regionMap.getY();
        for (int i = 0; i < xSize - 1; ++i) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = 0; j < ySize; ++j) {
                int otherType;
                int type = (int)this.regionMap.getNumber(i, j);
                if (type <= 1 || i + 1 >= this.regionNub || (otherType = (int)this.regionMap.getNumber(i + 1, j)) <= 1 || otherType == type || list.contains(otherType)) continue;
                RegionBody myRegion = this.regionBodyMap.get(type);
                RegionBody otherRegion = this.regionBodyMap.get(otherType);
                myRegion.mergeRegion(otherRegion);
                this.regionBodyMap.remove(otherType);
                list.add(otherType);
            }
        }
    }

    private void createMerge() throws Exception {
        int x = this.regionMap.getX();
        int y = this.regionMap.getY();
        int t = 0;
        boolean isZero = false;
        for (int i = 0; i < x; ++i) {
            if (!isZero) {
                ++t;
            }
            boolean isFirstOne = false;
            for (int j = 0; j < y; ++j) {
                int type = (int)this.regionMap.getNumber(i, j);
                if (type == 1) {
                    RegionBody regionBody;
                    if (this.regionBodyMap.containsKey(t)) {
                        regionBody = this.regionBodyMap.get(t);
                    } else {
                        regionBody = new RegionBody(this.regionMap, t, this.xSize, this.ySize);
                        this.regionBodyMap.put(t, regionBody);
                    }
                    regionBody.setPoint(i, j);
                    isFirstOne = true;
                    isZero = false;
                    continue;
                }
                if (!isFirstOne) continue;
                if (!isZero) {
                    ++t;
                }
                isZero = true;
            }
        }
    }

    private void sigmaPixel() throws Exception {
        int size = this.xSize * this.ySize;
        for (int i = 0; i < this.xSize * this.regionNub; i += this.xSize) {
            for (int j = 0; j < this.ySize * this.regionNub; j += this.ySize) {
                Matrix myMatrix = this.rainfallMap.getSonOfMatrix(i, j, this.xSize, this.ySize);
                int sigma = 0;
                for (int t = 0; t < this.xSize; ++t) {
                    for (int f = 0; f < this.ySize; ++f) {
                        if (!(myMatrix.getNumber(t, f) > 0.1)) continue;
                        ++sigma;
                    }
                }
                double cover = (double)sigma / (double)size;
                if (!(cover > this.rainTh)) continue;
                this.regionMap.setNub(i / this.xSize, j / this.ySize, 1.0);
            }
        }
        this.createMerge();
        this.merge();
    }

    private int getMinIndex(double[] array, double mySelf) {
        int minIdx = 0;
        for (int i = 0; i < array.length; ++i) {
            double nub = array[i];
            if (!(nub > -1.0) || !(nub < mySelf)) continue;
            minIdx |= 1 << i;
        }
        return minIdx;
    }
}

