/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.transFormer;

import java.util.List;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.transFormer.CodecBlock;
import org.dromara.transFormer.model.FirstDecoderModel;
import org.dromara.transFormer.seflAttention.LayNorm;
import org.dromara.transFormer.seflAttention.MultiSelfAttention;

public class FirstDecoderBlock {
    private final MultiSelfAttention multiSelfAttention;
    private final LayNorm attentionLayNorm;
    private final CodecBlock codecBlock;
    private CodecBlock lastEncoderBlock;

    public void setLastEncoderBlock(CodecBlock lastEncoderBlock) {
        this.lastEncoderBlock = lastEncoderBlock;
    }

    public FirstDecoderBlock(int multiNumber, int featureDimension, double studyPoint, CodecBlock codecBlock, int maxLength, boolean selfTimeCode, int coreNumber) throws Exception {
        this.attentionLayNorm = new LayNorm(1, featureDimension, null, this, studyPoint, coreNumber);
        this.multiSelfAttention = new MultiSelfAttention(multiNumber, studyPoint, 1, featureDimension, false, null, maxLength, selfTimeCode, coreNumber);
        this.multiSelfAttention.setLayNorm(this.attentionLayNorm);
        this.attentionLayNorm.setMultiSelfAttention(this.multiSelfAttention);
        this.codecBlock = codecBlock;
    }

    public FirstDecoderModel getModel() {
        FirstDecoderModel firstDecoderModel = new FirstDecoderModel();
        firstDecoderModel.setMultiSelfAttentionModel(this.multiSelfAttention.getModel());
        firstDecoderModel.setAttentionLayNormModel(this.attentionLayNorm.getModel());
        return firstDecoderModel;
    }

    public void insertModel(FirstDecoderModel firstDecoderModel) throws Exception {
        this.multiSelfAttention.insertModel(firstDecoderModel.getMultiSelfAttentionModel());
        this.attentionLayNorm.insertModel(firstDecoderModel.getAttentionLayNormModel());
    }

    public void backError(long eventID, Matrix error) throws Exception {
        this.attentionLayNorm.backErrorFromLine(error, eventID);
        this.lastEncoderBlock.encoderBackStart(eventID);
    }

    public void sendOutputMatrix(long eventID, Matrix out, boolean isStudy, OutBack outBack, List<Integer> E, boolean outAllPro) throws Exception {
        Matrix c = this.lastEncoderBlock.getOutMatrix(eventID);
        this.lastEncoderBlock.removeOutMatrix(eventID);
        this.codecBlock.sendInputMatrix(eventID, out, isStudy, outBack, E, c, outAllPro);
    }

    public void sendInputMatrix(long eventID, Matrix feature, boolean isStudy, OutBack outBack, List<Integer> E, boolean outAllPro) throws Exception {
        this.multiSelfAttention.sendMatrixMessage(eventID, feature, isStudy, outBack, E, null, outAllPro);
    }
}

