/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.transFormer;

import java.util.ArrayList;
import java.util.List;
import org.dromara.function.Tanh;
import org.dromara.i.OutBack;
import org.dromara.matrixTools.Matrix;
import org.dromara.matrixTools.MatrixOperation;
import org.dromara.transFormer.CodecBlock;
import org.dromara.transFormer.model.LineBlockModel;
import org.dromara.transFormer.nerve.HiddenNerve;
import org.dromara.transFormer.nerve.Nerve;
import org.dromara.transFormer.nerve.OutNerve;
import org.dromara.transFormer.nerve.SoftMax;

public class LineBlock {
    private final List<HiddenNerve> hiddenNerveList = new ArrayList<HiddenNerve>();
    private final List<OutNerve> outNerveList = new ArrayList<OutNerve>();
    private final CodecBlock lastCodecBlock;
    private Matrix allError;
    private final int featureDimension;
    private int backNumber = 0;
    private final MatrixOperation matrixOperation;

    public LineBlockModel getModel() {
        LineBlockModel lineBlockModel = new LineBlockModel();
        ArrayList<double[][]> hiddenNerveModel = new ArrayList<double[][]>();
        ArrayList<double[][]> outNerveModel = new ArrayList<double[][]>();
        for (HiddenNerve hiddenNerve : this.hiddenNerveList) {
            hiddenNerveModel.add(hiddenNerve.getModel());
        }
        for (OutNerve outNerve : this.outNerveList) {
            outNerveModel.add(outNerve.getModel());
        }
        lineBlockModel.setHiddenNervesModel(hiddenNerveModel);
        lineBlockModel.setOutNervesModel(outNerveModel);
        return lineBlockModel;
    }

    public void insertModel(LineBlockModel lineBlockModel) throws Exception {
        int i;
        List<double[][]> hiddenNerveModel = lineBlockModel.getHiddenNervesModel();
        List<double[][]> outNerveModel = lineBlockModel.getOutNervesModel();
        for (i = 0; i < this.hiddenNerveList.size(); ++i) {
            this.hiddenNerveList.get(i).insertModel(hiddenNerveModel.get(i));
        }
        for (i = 0; i < this.outNerveList.size(); ++i) {
            this.outNerveList.get(i).insertModel(outNerveModel.get(i));
        }
    }

    public LineBlock(int typeNumber, int featureDimension, double studyPoint, CodecBlock lastCodecBlock, boolean showLog, int regularModel, double regular, int coreNumber, double timePunValue) throws Exception {
        this.featureDimension = featureDimension;
        this.lastCodecBlock = lastCodecBlock;
        this.matrixOperation = new MatrixOperation(coreNumber);
        SoftMax softMax = new SoftMax(this.outNerveList, showLog, typeNumber, typeNumber, typeNumber, timePunValue);
        ArrayList<Nerve> hiddenNerves = new ArrayList<Nerve>();
        for (int i = 0; i < featureDimension; ++i) {
            HiddenNerve hiddenNerve = new HiddenNerve(i + 1, 1, studyPoint, new Tanh(), featureDimension, typeNumber, this, regularModel, regular, coreNumber);
            hiddenNerves.add(hiddenNerve);
            this.hiddenNerveList.add(hiddenNerve);
        }
        ArrayList<Nerve> outNerves = new ArrayList<Nerve>();
        for (int i = 0; i < typeNumber; ++i) {
            OutNerve outNerve = new OutNerve(i + 1, studyPoint, featureDimension, featureDimension, typeNumber, softMax, regularModel, regular, coreNumber);
            outNerve.connectFather(hiddenNerves);
            outNerves.add(outNerve);
            this.outNerveList.add(outNerve);
        }
        for (Nerve nerve : hiddenNerves) {
            nerve.connect(outNerves);
        }
    }

    public void sendParameter(long eventID, Matrix feature, boolean isStudy, OutBack outBack, List<Integer> E, boolean outAllPro) throws Exception {
        for (HiddenNerve hiddenNerve : this.hiddenNerveList) {
            hiddenNerve.postMessage(eventID, feature, isStudy, outBack, E, outAllPro);
        }
    }

    public void backError(long eventID, Matrix errorMatrix) throws Exception {
        ++this.backNumber;
        this.allError = this.allError == null ? errorMatrix : this.matrixOperation.add(errorMatrix, this.allError);
        if (this.backNumber == this.featureDimension) {
            this.backNumber = 0;
            Matrix error = this.allError.getSonOfMatrix(0, 0, this.allError.getX(), this.allError.getY() - 1);
            this.allError = null;
            this.lastCodecBlock.backError(eventID, error);
        }
    }
}

