/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.yolo;

import java.util.ArrayList;
import java.util.List;
import org.dromara.function.ReLu;
import org.dromara.function.Tanh;
import org.dromara.nerveCenter.NerveManager;
import org.dromara.yolo.YoloBody;
import org.dromara.yolo.YoloConfig;

public class TypeBody {
    private int typeID;
    private int mappingID;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private int minWidth = -1;
    private int minHeight = -1;
    private int winWidth = 0;
    private int winHeight = 0;
    private final NerveManager positonNerveManager;
    private List<YoloBody> yoloBodies = new ArrayList<YoloBody>();

    public int getWinWidth() {
        return this.winWidth;
    }

    public int getWinHeight() {
        return this.winHeight;
    }

    public NerveManager getPositonNerveManager() {
        return this.positonNerveManager;
    }

    public TypeBody(YoloConfig yoloConfig, int minWinWidth, int minWinHeight) throws Exception {
        this.winWidth = minWinWidth;
        this.winHeight = minWinHeight;
        this.positonNerveManager = new NerveManager(3, yoloConfig.getHiddenNerveNub(), 5, 1, new Tanh(), yoloConfig.getLineStudy(), yoloConfig.getRegularModel(), yoloConfig.getRegular(), yoloConfig.getCoreNumber());
        this.positonNerveManager.initImageNet(2, yoloConfig.getKernelSize(), minWinHeight, minWinWidth, false, yoloConfig.isShowLog(), yoloConfig.getConvStudy(), new ReLu());
    }

    public double getRealWidth(double width) {
        if (this.maxWidth == this.minWidth) {
            return this.maxWidth;
        }
        return (double)(this.maxWidth - this.minWidth) * width + (double)this.minWidth;
    }

    public double getRealHeight(double height) {
        if (this.maxHeight == this.minHeight) {
            return this.maxHeight;
        }
        return (double)(this.maxHeight - this.minHeight) * height + (double)this.minHeight;
    }

    public double getOneWidth(int width) {
        if (this.maxWidth == this.minWidth) {
            return 1.0;
        }
        return (double)(width - this.minWidth) / (double)(this.maxWidth - this.minWidth);
    }

    public double getOneHeight(int height) {
        if (this.maxHeight == this.minHeight) {
            return 1.0;
        }
        return (double)(height - this.minHeight) / (double)(this.maxHeight - this.minHeight);
    }

    public void insertYoloBody(YoloBody yoloBody) {
        if (yoloBody.getWidth() > this.maxWidth) {
            this.maxWidth = yoloBody.getWidth();
        }
        if (yoloBody.getHeight() > this.maxHeight) {
            this.maxHeight = yoloBody.getHeight();
        }
        if (this.minWidth < 0 || yoloBody.getWidth() < this.minWidth) {
            this.minWidth = yoloBody.getWidth();
        }
        if (this.minHeight < 0 || yoloBody.getHeight() < this.minHeight) {
            this.minHeight = yoloBody.getHeight();
        }
        this.yoloBodies.add(yoloBody);
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public List<YoloBody> getYoloBodies() {
        return this.yoloBodies;
    }

    public void setYoloBodies(List<YoloBody> yoloBodies) {
        this.yoloBodies = yoloBodies;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public void setTypeID(int typeID) {
        this.typeID = typeID;
    }

    public int getMappingID() {
        return this.mappingID;
    }

    public void setMappingID(int mappingID) {
        this.mappingID = mappingID;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

