package cn.myeasyai.util;

import cn.myeasyai.face.FaceModel;
import com.alibaba.fastjson.JSONObject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

/**
 * 获取文件基础类
 * @author fushoujiang
 * @version 1.0
 */
public class SourceUtil {


    /**
     * 获取resource下文件
     * @param fileName 文件名称，比如avgFace.png
     * @return File
     */
    public static File getResourceFile(String fileName) {
        return new File(SourceUtil.class.getClassLoader().getResource(fileName).getPath());
    }

    public static FaceModel readCreatorModel2(String fileName) {
        final File file = getResourceFile(fileName);
        String a = readPaper(file);
        return JSONObject.parseObject(a, FaceModel.class);
    }

    private static String readPaper(File file) {
        InputStream read = null;
        String context = null;
        try {
            read = Files.newInputStream(file.toPath());
            byte[] bt = new byte[read.available()];
            read.read(bt);
            context = new String(bt, StandardCharsets.UTF_8);
            read.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (read != null) {
                try {
                    read.close(); //确保关闭
                } catch (IOException el) {

                }
            }
        }
        return context;
    }

}
