/*
 * Decompiled with CFR 0.152.
 */
package cn.myeasyai;

import cn.myeasyai.face.ErrorMessage;
import cn.myeasyai.face.Face;
import cn.myeasyai.face.FaceFactory;
import cn.myeasyai.face.FaceMessage;
import cn.myeasyai.face.FaceModel;
import cn.myeasyai.face.FaceTestConfig;
import cn.myeasyai.temple.AllTemple;
import cn.myeasyai.temple.TestBody;
import cn.myeasyai.util.SourceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.tools.ImageTools;
import org.dromara.easyai.tools.Picture;

public class App {
    private static Face face;

    public static void main(String[] args) throws Exception {
        App.init();
        App.test("/Users/lidapeng/job/faceData/myFaceTest");
        App.test2();
        App.test3();
    }

    public static void test3() throws Exception {
        MatrixOperation matrixOperation = new MatrixOperation();
        ThreeChannelMatrix m1 = Picture.getThreeMatrix((String)"/Users/lidapeng/job/faceData/myFaceTest/062896.jpg", (boolean)true);
        ThreeChannelMatrix m2 = Picture.getThreeMatrix((String)"/Users/lidapeng/job/faceData/a3.jpg", (boolean)true);
        ThreeChannelMatrix m3 = Picture.getThreeMatrix((String)"/Users/lidapeng/job/faceData/a7.jpg", (boolean)true);
        FaceMessage faceMessage1 = face.look(m1, 1L, 30).getFaceMessage();
        FaceMessage faceMessage2 = face.look(m2, 2L, 30).getFaceMessage();
        FaceMessage faceMessage3 = face.look(m3, 3L, 30).getFaceMessage();
        double a = matrixOperation.getEDistByMatrix(faceMessage1.getFeature(), faceMessage2.getFeature());
        double b = matrixOperation.getEDistByMatrix(faceMessage2.getFeature(), faceMessage3.getFeature());
        System.out.println(a);
        System.out.println(b);
        ImageTools.writeImage((ThreeChannelMatrix)faceMessage1.getChannel(), (String)"/Users/lidapeng/job/faceData/test/b1.jpg");
        ImageTools.writeImage((ThreeChannelMatrix)faceMessage2.getChannel(), (String)"/Users/lidapeng/job/faceData/test/b2.jpg");
        ImageTools.writeImage((ThreeChannelMatrix)faceMessage3.getChannel(), (String)"/Users/lidapeng/job/faceData/test/b3.jpg");
    }

    public static void test2() throws Exception {
        ThreeChannelMatrix m = Picture.getThreeMatrix((String)"/Users/lidapeng/job/faceData/m8.jpg", (boolean)true);
        ImageTools imageTools = new ImageTools();
        ImageTools.writeImage((ThreeChannelMatrix)m, (String)"/Users/lidapeng/job/faceData/test/dd.jpg");
        FaceMessage faceMessage = face.look(m, 1L, 30).getFaceMessage();
        if (faceMessage != null) {
            System.out.println(faceMessage.getDist());
            ThreeChannelMatrix threeChannelMatrix = faceMessage.getChannel();
            ImageTools.writeImage((ThreeChannelMatrix)threeChannelMatrix, (String)"/Users/lidapeng/job/faceData/test/cc.jpg");
        } else {
            System.out.println("\u8d28\u91cf\u592a\u5dee");
        }
    }

    public static ErrorMessage look(File file, long eventID, String url) throws Exception {
        ThreeChannelMatrix pic = url == null ? Picture.getThreeMatrix((File)file, (boolean)true) : Picture.getThreeMatrix((String)url, (boolean)true);
        FaceTestConfig faceTestConfig = new FaceTestConfig();
        return face.look(pic, eventID, faceTestConfig.getSecondExplore());
    }

    public static void test(String templeUrl) throws Exception {
        MatrixOperation operation = new MatrixOperation();
        File folder = new File(templeUrl);
        File[] files = folder.listFiles();
        FaceMessage faceMessage1 = App.look(null, 1L, "/Users/lidapeng/job/faceData/a3.jpg").getFaceMessage();
        Matrix myMatrix = faceMessage1.getFeature();
        ArrayList<TestBody> testBodies = new ArrayList<TestBody>();
        TestBody testBody1 = new TestBody();
        FaceMessage faceMessage2 = App.look(null, 2L, "/Users/lidapeng/job/faceData/a7.jpg").getFaceMessage();
        Matrix otherMatrix = faceMessage2.getFeature();
        ImageTools.writeImage((ThreeChannelMatrix)faceMessage1.getChannel(), (String)"/Users/lidapeng/job/faceData/test/b1.jpg");
        ImageTools.writeImage((ThreeChannelMatrix)faceMessage2.getChannel(), (String)"/Users/lidapeng/job/faceData/test/b2.jpg");
        testBody1.setMatrix(otherMatrix);
        testBody1.setFileName("\u547d\u4e2d\u76ee\u6807\u6587\u4ef6");
        testBodies.add(testBody1);
        double dd = operation.getEDistByMatrix(myMatrix, otherMatrix);
        int index = 1;
        double maxNorm = 0.0;
        for (File file : files) {
            TestBody testBody = new TestBody();
            String fileName = file.getName();
            if (fileName.contains(".DS")) continue;
            System.out.println(fileName);
            ErrorMessage errorMessage = App.look(file, index, null);
            if (errorMessage.getErrorCode() != 0) continue;
            FaceMessage faceMessage = errorMessage.getFaceMessage();
            if (faceMessage.getDist() > maxNorm) {
                maxNorm = faceMessage.getDist();
            }
            Matrix feature = faceMessage.getFeature();
            testBody.setFileName(fileName);
            testBody.setMatrix(feature);
            testBodies.add(testBody);
            if (++index == 100) break;
        }
        String url = "";
        double minDist = -1.0;
        for (TestBody testBody : testBodies) {
            double dist = operation.getEDistByMatrix(myMatrix, testBody.getMatrix());
            if (!(minDist < 0.0) && !(dist < minDist)) continue;
            minDist = dist;
            url = testBody.getFileName();
        }
        System.out.println("\u6700\u76f8\u8fd1\u7684\u4eba\u8138===" + url + ",dist==" + minDist + ",dd:" + dd + ",minNorm==" + maxNorm);
    }

    public static void init() throws Exception {
        face = FaceFactory.getFace();
    }

    public static void study() throws Exception {
        ThreeChannelMatrix avgMatrix = Picture.getThreeMatrix((String)"/Users/lidapeng/job/faceData/test/avgFace.png", (boolean)true);
        ArrayList<AllTemple> allTemples = new ArrayList<AllTemple>();
        AllTemple allTemple1 = new AllTemple();
        AllTemple allTemple2 = new AllTemple();
        allTemples.add(allTemple1);
        allTemples.add(allTemple2);
        allTemple1.setTempleUrl("/Users/lidapeng/job/faceData/biaozhu");
        allTemple1.setPictureUrl("/Users/lidapeng/job/faceData/success");
        allTemple2.setTempleUrl("/Users/lidapeng/job/faceData/biaozhu2");
        allTemple2.setPictureUrl("/Users/lidapeng/job/faceData/success2");
        Face face = new Face(new FaceTestConfig(), avgMatrix);
        face.insertModel(App.readCreatorModel2());
        face.facePositionStudy(allTemples);
        FaceModel faceModel = face.getModel();
        App.writeModel(JSON.toJSONString((Object)faceModel), "/Users/lidapeng/job/faceData/model/face.json");
    }

    private static void writeModel(String model, String url) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(Files.newOutputStream(Paths.get(url, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
        out.write(model);
        out.close();
    }

    private static FaceModel readCreatorModel2() {
        File file = SourceUtil.getResourceFile("face.json");
        String a = App.readPaper(file);
        return (FaceModel)JSONObject.parseObject((String)a, FaceModel.class);
    }

    private static FaceModel readCreatorModel(int i) {
        File file = new File("/Users/lidapeng/job/faceData/model/model" + i + ".json");
        String a = App.readPaper(file);
        return (FaceModel)JSONObject.parseObject((String)a, FaceModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPaper(File file) {
        InputStream read = null;
        String context = null;
        try {
            read = Files.newInputStream(file.toPath(), new OpenOption[0]);
            byte[] bt = new byte[read.available()];
            read.read(bt);
            context = new String(bt, StandardCharsets.UTF_8);
            read.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }
}

