/*
 * Decompiled with CFR 0.152.
 */
package cn.myeasyai.face;

import cn.myeasyai.face.ErrorMessage;
import cn.myeasyai.face.FaceMessage;
import cn.myeasyai.face.FaceModel;
import cn.myeasyai.face.FaceTestConfig;
import cn.myeasyai.face.SecondPosition;
import cn.myeasyai.temple.AllTemple;
import cn.myeasyai.temple.MyTemples;
import cn.myeasyai.temple.Temple;
import cn.myeasyai.temple.TempleMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.easyai.entity.Box;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.i.PsoFunction;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.nerveCenter.NerveManager;
import org.dromara.easyai.nerveEntity.SensoryNerve;
import org.dromara.easyai.pso.PSO;
import org.dromara.easyai.tools.NMS;
import org.dromara.easyai.tools.Picture;
import org.dromara.easyai.yolo.PositionBack;
import org.dromara.easyai.yolo.TypeBody;
import org.dromara.easyai.yolo.TypeModel;
import org.dromara.easyai.yolo.YoloBody;
import org.dromara.easyai.yolo.YoloConfig;
import org.dromara.easyai.yolo.YoloMessage;
import org.dromara.easyai.yolo.YoloModel;

public class Face {
    public YoloConfig yoloConfig = new YoloConfig();
    private final MatrixOperation matrixOperation = new MatrixOperation();
    private TypeBody trTypeBody;
    private final int faceWidth;
    private final int faceHeight;
    private final int lastXSize;
    private final int lastYSize;
    private final int pictureHeight;
    private final int pictureWidth;
    private final int minFaceWidth;
    private final int minFaceHeight;
    private final ThreeChannelMatrix avg;
    private final Matrix avgLBP;
    private final double trustTh;
    private final int moveSize;

    public Face(FaceTestConfig faceTestConfig, ThreeChannelMatrix avg) throws Exception {
        this.pictureWidth = faceTestConfig.getPictureWidth();
        this.trustTh = faceTestConfig.getTrustTh();
        this.moveSize = faceTestConfig.getMoveSize();
        this.pictureHeight = faceTestConfig.getPictureHeight();
        this.minFaceHeight = faceTestConfig.getMinFaceHeight();
        this.minFaceWidth = faceTestConfig.getMinFaceWidth();
        this.faceWidth = faceTestConfig.getPictureWidth() / 3;
        this.faceHeight = faceTestConfig.getPictureHeight() / 3;
        this.lastXSize = faceTestConfig.getLastXSize();
        this.lastYSize = faceTestConfig.getLastYSize();
        this.yoloConfig.setContainIouTh(0.2);
        this.yoloConfig.setWindowWidth(faceTestConfig.getPictureWidth() / 3);
        this.yoloConfig.setWindowHeight(faceTestConfig.getPictureHeight() / 3);
        this.yoloConfig.setRegular(0.01);
        this.yoloConfig.setRegularModel(1);
        this.avg = avg;
        if (avg != null) {
            int XSize = (int)((double)avg.getX() * 0.7);
            int YSize = avg.getY();
            ThreeChannelMatrix avm = avg.cutChannel(0, 0, XSize, YSize);
            this.avgLBP = avm.getLBPMatrix();
        } else {
            this.avgLBP = null;
        }
    }

    public void insertModel(FaceModel faceModel) throws Exception {
        YoloModel yoloModel = faceModel.getYoloModel();
        List typeModels = yoloModel.getTypeModels();
        this.trTypeBody = this.getTypeBody((TypeModel)typeModels.get(0));
    }

    private TypeBody getTypeBody(TypeModel typeModel) throws Exception {
        TypeBody typeBody = new TypeBody(this.yoloConfig, this.yoloConfig.getWindowWidth(), this.yoloConfig.getWindowHeight());
        typeBody.setTypeID(typeModel.getTypeID());
        typeBody.setMappingID(typeModel.getMappingID());
        typeBody.setMinWidth(typeModel.getMinWidth());
        typeBody.setMinHeight(typeModel.getMinHeight());
        typeBody.setMaxWidth(typeModel.getMaxWidth());
        typeBody.setMaxHeight(typeModel.getMaxHeight());
        typeBody.getPositonNerveManager().insertConvModel(typeModel.getPositionModel());
        return typeBody;
    }

    public FaceModel getModel() throws Exception {
        FaceModel faceModel = new FaceModel();
        YoloModel yoloModel = new YoloModel();
        faceModel.setYoloModel(yoloModel);
        ArrayList<TypeModel> typeModels = new ArrayList<TypeModel>();
        typeModels.add(this.getTypeModel(this.trTypeBody));
        yoloModel.setTypeModels(typeModels);
        return faceModel;
    }

    private TypeModel getTypeModel(TypeBody typeBody) throws Exception {
        TypeModel typeModel = new TypeModel();
        typeModel.setTypeID(typeBody.getTypeID());
        typeModel.setMappingID(typeBody.getMappingID());
        typeModel.setMinHeight(typeBody.getMinHeight());
        typeModel.setMinWidth(typeBody.getMinWidth());
        typeModel.setMaxWidth(typeBody.getMaxWidth());
        typeModel.setMaxHeight(typeBody.getMaxHeight());
        typeModel.setPositionModel(typeBody.getPositonNerveManager().getConvModel());
        return typeModel;
    }

    private Box getBox(int i, int j, int maxX, int maxY, TypeBody typeBody, double distX, double distY, double pWidth, double pHeight, double trust) {
        boolean des = false;
        double centerX = (double)i - distX * (double)this.pictureHeight;
        double centerY = (double)j - distY * (double)this.pictureHeight;
        int width = (int)typeBody.getRealWidth(pWidth);
        int height = (int)typeBody.getRealHeight(pHeight);
        int realX = (int)(centerX - (double)(height / 2));
        int realY = (int)(centerY - (double)(width / 2));
        if (realX < 0) {
            des = true;
        }
        if (realY < 0) {
            des = true;
        }
        if (realX + height > maxX) {
            des = true;
        }
        if (realY + width > maxY) {
            des = true;
        }
        Box box = null;
        if (!des && trust > 0.4) {
            box = new Box();
            box.setX(realX);
            box.setY(realY);
            box.setxSize(height);
            box.setySize(width);
            box.setConfidence(trust);
            box.setTypeID(typeBody.getTypeID());
        }
        return box;
    }

    public ThreeChannelMatrix uniform(ThreeChannelMatrix threeChannelMatrix) throws Exception {
        if (threeChannelMatrix.getX() == this.pictureHeight && threeChannelMatrix.getY() == this.pictureWidth) {
            return threeChannelMatrix;
        }
        ThreeChannelMatrix sTrMatrix = threeChannelMatrix.scale(true, (double)this.pictureWidth);
        ThreeChannelMatrix myThreeMatrix = this.fillColor(sTrMatrix, this.pictureHeight, this.pictureWidth);
        if (myThreeMatrix == null) {
            myThreeMatrix = sTrMatrix;
        }
        return myThreeMatrix;
    }

    private int getLBPValue(Matrix matrix) throws Exception {
        int value = 0;
        double avg = matrix.getAVG();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == 1 && j == 1) continue;
                value <<= 1;
                if (!(matrix.getNumber(i, j) > avg)) continue;
                value |= 1;
            }
        }
        return value;
    }

    public Matrix lbpMatrix(Matrix addMatrix) throws Exception {
        int x = addMatrix.getX();
        int y = addMatrix.getY();
        Matrix matrix = new Matrix(x / 3, y / 3);
        for (int i = 0; i <= x - 3; i += 3) {
            for (int j = 0; j <= y - 3; j += 3) {
                Matrix aMatrix = addMatrix.getSonOfMatrix(i, j, 3, 3);
                int lbp = this.getLBPValue(aMatrix);
                matrix.setNub(i / 3, j / 3, (double)lbp);
            }
        }
        return matrix;
    }

    public ErrorMessage look(ThreeChannelMatrix face, long eventID, int secondExplore) throws Exception {
        FaceMessage faceMessage = null;
        if (this.avg != null) {
            ThreeChannelMatrix th = this.uniform(face);
            int x = th.getX();
            int y = th.getY();
            ArrayList<Box> trBoxes = new ArrayList<Box>();
            NMS nms = new NMS(this.yoloConfig.getIouTh());
            int width = this.yoloConfig.getWindowWidth();
            int height = this.yoloConfig.getWindowHeight();
            for (int i = 0; i <= x - height; i += height) {
                for (int j = 0; j <= y - width; j += width) {
                    PositionBack trPositionBack = new PositionBack();
                    ThreeChannelMatrix myTh = th.cutChannel(i, j, height, width);
                    List trSensoryNerves = this.trTypeBody.getPositonNerveManager().getSensoryNerves();
                    this.study(eventID, trSensoryNerves, myTh, false, null, (OutBack)trPositionBack);
                    Box trBox = this.getBox(i, j, x, y, this.trTypeBody, trPositionBack.getDistX(), trPositionBack.getDistY(), trPositionBack.getWidth(), trPositionBack.getHeight(), trPositionBack.getTrust());
                    if (trBox == null) continue;
                    trBoxes.add(trBox);
                }
            }
            ErrorMessage errorMessage = new ErrorMessage();
            if (!trBoxes.isEmpty()) {
                List myTrBoxes = nms.start(trBoxes);
                Box box = this.getTrustBox(myTrBoxes);
                FaceMessage myFaceMessage = this.secondCorrect(box, th, secondExplore);
                if (myFaceMessage != null) {
                    double dist = myFaceMessage.getDist();
                    if (dist < this.trustTh) {
                        faceMessage = myFaceMessage;
                        errorMessage.setErrorCode(0);
                        errorMessage.setErrorMessage("\u6b63\u5e38");
                    } else {
                        errorMessage.setErrorCode(3);
                        errorMessage.setErrorMessage("\u627e\u4e0d\u5230\u4eba\u8138,\u7167\u7247\u66dd\u5149\u8fc7\u9ad8\uff0c\u6216\u8005\u8fc7\u6697\uff0c\u6216\u8005\u9634\u9633\u8138");
                    }
                } else {
                    errorMessage.setErrorCode(2);
                    errorMessage.setErrorMessage("\u4eba\u8138\u6bd4\u4f8b\u5728\u7167\u7247\u5185\u8fc7\u5c0f\u6216\u8005\u8fc7\u5927");
                }
                errorMessage.setFaceMessage(faceMessage);
            } else {
                errorMessage.setErrorCode(1);
                errorMessage.setErrorMessage("\u627e\u4e0d\u5230\u4eba\u8138\uff0c\u6ca1\u6709\u5408\u6cd5\u7684\u4eba\u8138");
            }
            return errorMessage;
        }
        throw new Exception("\u6ca1\u6709\u914d\u7f6e\u5e73\u5747\u8138");
    }

    private Box getTrustBox(List<Box> myTrBoxes) {
        double maxTrust = 0.0;
        Box myBox = null;
        for (Box box : myTrBoxes) {
            double trust = box.getConfidence();
            if (!(trust > maxTrust)) continue;
            maxTrust = trust;
            myBox = box;
        }
        return myBox;
    }

    private FaceMessage secondCorrect(Box box, ThreeChannelMatrix pic, int secondExplore) throws Exception {
        int bx = pic.getX();
        int by = pic.getY();
        int x = box.getX();
        int y = box.getY();
        int minX = x - this.moveSize;
        int maxX = x + this.moveSize;
        int minY = y - this.moveSize;
        int maxY = y + this.moveSize;
        int xSize = box.getxSize();
        int ySize = box.getySize();
        int minXSize = xSize - this.moveSize;
        int maxXSize = xSize + this.moveSize;
        int minYSize = ySize - this.moveSize;
        int maxYSize = ySize + this.moveSize;
        if (minX < 0) {
            minX = 0;
        }
        if (maxX >= bx - xSize) {
            maxX = bx - xSize - 1;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxY >= by - ySize) {
            maxY = by - ySize - 1;
        }
        double[] minBorder = new double[]{minX, minY, minXSize, minYSize};
        double[] maxBorder = new double[]{maxX, maxY, maxXSize, maxYSize};
        Matrix avg = this.getMatrixE(this.avg);
        SecondPosition secondPosition = new SecondPosition(avg, pic, this);
        PSO pso = new PSO(4, minBorder, maxBorder, secondExplore, secondExplore, (PsoFunction)secondPosition, 0.5, 2.0, 2.0, false, (double)this.moveSize / 2.0, 2.0);
        pso.start();
        double[] bestPosition = pso.getAllBest();
        int realX = (int)bestPosition[0];
        int realY = (int)bestPosition[1];
        int realXSize = (int)bestPosition[2];
        int realYSize = (int)bestPosition[3];
        if (realXSize < this.minFaceHeight || realYSize < this.minFaceWidth) {
            return null;
        }
        FaceMessage faceMessage = new FaceMessage();
        ThreeChannelMatrix tm = pic.cutChannel(realX, realY, realXSize, realYSize);
        ThreeChannelMatrix sTrMatrix = tm.scale(true, (double)this.faceWidth);
        ThreeChannelMatrix myThreeMatrix = this.fillColor(sTrMatrix, this.faceHeight, this.faceWidth);
        if (myThreeMatrix == null) {
            myThreeMatrix = sTrMatrix;
        }
        int XSize = (int)((double)myThreeMatrix.getX() * 0.7);
        int YSize = myThreeMatrix.getY();
        myThreeMatrix = myThreeMatrix.cutChannel(0, 0, XSize, YSize);
        faceMessage.setChannel(myThreeMatrix);
        Matrix lbpMatrix = myThreeMatrix.getLBPMatrix();
        double normDist = this.matrixOperation.getEDistByMatrix(lbpMatrix, this.avgLBP);
        Matrix lbpMatrixT = this.lbpMatrix(lbpMatrix);
        faceMessage.setDist(normDist);
        faceMessage.setFeature(lbpMatrixT);
        return faceMessage;
    }

    private List<TempleMessage> anySort(List<TempleMessage> sentences) {
        Random random = new Random();
        ArrayList<TempleMessage> sent = new ArrayList<TempleMessage>();
        int time = sentences.size();
        for (int i = 0; i < time; ++i) {
            int size = sentences.size();
            int index = random.nextInt(size);
            sent.add(sentences.get(index));
            sentences.remove(index);
        }
        return sent;
    }

    private ThreeChannelMatrix getFaceMatrix(int height, int width) {
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        Matrix matrixR = new Matrix(height, width);
        Matrix matrixG = new Matrix(height, width);
        Matrix matrixB = new Matrix(height, width);
        Matrix matrixH = new Matrix(height, width);
        threeChannelMatrix.setX(height);
        threeChannelMatrix.setY(width);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        return threeChannelMatrix;
    }

    private ThreeChannelMatrix fillColor(ThreeChannelMatrix picture, int heightSize, int widthSize) throws Exception {
        int myFaceHeight = picture.getX();
        int sub = myFaceHeight - heightSize;
        int fillHeight = sub / 2;
        if (fillHeight == 0) {
            fillHeight = 1;
        }
        ThreeChannelMatrix fillMatrix = null;
        if (sub > 0) {
            fillMatrix = picture.cutChannel(fillHeight, 0, heightSize, widthSize);
        } else if (sub < 0) {
            fillMatrix = this.getFaceMatrix(heightSize, widthSize);
            fillMatrix.fill(Math.abs(fillHeight), 0, picture);
        }
        return fillMatrix;
    }

    public Matrix lookFace(ThreeChannelMatrix picture) throws Exception {
        ThreeChannelMatrix sTrMatrix = picture.scale(true, (double)this.faceWidth);
        ThreeChannelMatrix myThreeMatrix = this.fillColor(sTrMatrix, this.faceHeight, this.faceWidth);
        if (myThreeMatrix == null) {
            myThreeMatrix = sTrMatrix;
        }
        return this.getMatrixE(myThreeMatrix);
    }

    public Matrix getMatrixE(ThreeChannelMatrix subMatrix) throws Exception {
        int x = subMatrix.getX();
        int y = subMatrix.getY();
        int XStep = x / this.lastXSize + 1;
        int YStep = y / this.lastYSize + 1;
        Matrix matrixR = subMatrix.getMatrixR();
        Matrix matrixG = subMatrix.getMatrixG();
        Matrix matrixB = subMatrix.getMatrixB();
        Matrix myMatrix = new Matrix(this.lastXSize, this.lastYSize);
        for (int i = 0; i <= x - XStep; i += XStep) {
            for (int j = 0; j <= y - YStep; j += YStep) {
                double tr = matrixR.getSonOfMatrix(i, j, XStep, YStep).getAVG();
                double tg = matrixG.getSonOfMatrix(i, j, XStep, YStep).getAVG();
                double tb = matrixB.getSonOfMatrix(i, j, XStep, YStep).getAVG();
                double value = tr + tg + tb;
                int tx = i / XStep;
                int ty = j / YStep;
                myMatrix.setNub(tx, ty, value);
            }
        }
        return this.matrixOperation.softMaxByMatrix(myMatrix);
    }

    public void facePositionStudy(List<AllTemple> allTemples) throws Exception {
        TypeBody trTypeBody;
        Temple temple = new Temple();
        MyTemples templeMessages = temple.readALlTemple(allTemples, this.yoloConfig);
        List<TempleMessage> temples = this.anySort(templeMessages.getTempleMessages());
        this.trTypeBody = trTypeBody = templeMessages.getTrTypeBody();
        NMS nms = new NMS(this.yoloConfig.getContainIouTh());
        double size = temples.size();
        int index = 0;
        for (TempleMessage templeMessage : temples) {
            double jin = (double)(++index) / size * 100.0;
            System.out.println("\u8bad\u7ec3\u8fdb\u5ea6=====================" + jin + "%");
            String fileName = templeMessage.getFileName();
            YoloBody trYoloBody = templeMessage.getTrYoloBody();
            ThreeChannelMatrix threeChannelMatrix = Picture.getThreeMatrix((String)fileName, (boolean)true);
            this.studyPicture(threeChannelMatrix, trYoloBody, trTypeBody, nms);
        }
        System.out.println("\u8bad\u7ec3\u5b8c\u6bd5=================");
    }

    private void studyPicture(ThreeChannelMatrix picture, YoloBody yoloBody, TypeBody typeBody, NMS nms) throws Exception {
        int x = picture.getX();
        int y = picture.getY();
        int width = this.yoloConfig.getWindowWidth();
        int height = this.yoloConfig.getWindowHeight();
        int widthStep = (int)((double)width * 0.5);
        int heightStep = (int)((double)height * 0.5);
        NerveManager trPositionManager = typeBody.getPositonNerveManager();
        for (int i = 0; i <= x - height; i += heightStep) {
            for (int j = 0; j <= y - width; j += widthStep) {
                Box testBox = new Box();
                testBox.setX(i);
                testBox.setY(j);
                testBox.setxSize(height);
                testBox.setySize(width);
                YoloMessage yoloMessage = this.containSample(nms, yoloBody, testBox, typeBody);
                ThreeChannelMatrix small = picture.cutChannel(i, j, height, width);
                if (yoloMessage == null) continue;
                HashMap<Integer, Double> positionE = new HashMap<Integer, Double>();
                positionE.put(1, yoloMessage.getDistX());
                positionE.put(2, yoloMessage.getDistY());
                positionE.put(3, yoloMessage.getWidth());
                positionE.put(4, yoloMessage.getHeight());
                positionE.put(5, yoloMessage.getTrust());
                this.study(1L, trPositionManager.getSensoryNerves(), small, true, positionE, null);
            }
        }
    }

    private YoloMessage containSample(NMS nms, YoloBody yoloBody, Box testBox, TypeBody typeBody) {
        YoloMessage yoloMessage = null;
        Box box = new Box();
        box.setX(yoloBody.getY());
        box.setY(yoloBody.getX());
        box.setxSize(yoloBody.getHeight());
        box.setySize(yoloBody.getWidth());
        double iou = nms.getSRatio(testBox, box, false);
        if (iou > this.yoloConfig.getContainIouTh()) {
            yoloMessage = new YoloMessage();
            int centerX = box.getX() + box.getxSize() / 2;
            int centerY = box.getY() + box.getySize() / 2;
            double distX = (double)(testBox.getX() - centerX) / (double)this.pictureHeight;
            double distY = (double)(testBox.getY() - centerY) / (double)this.pictureHeight;
            double height = typeBody.getOneHeight(box.getxSize());
            double width = typeBody.getOneWidth(box.getySize());
            double trust = 0.0;
            if (centerX >= testBox.getX() && centerX <= testBox.getX() + testBox.getxSize() && centerY >= testBox.getY() && centerY <= testBox.getY() + testBox.getySize()) {
                trust = 1.0;
            }
            yoloMessage.setWidth(width);
            yoloMessage.setHeight(height);
            yoloMessage.setDistX(distX);
            yoloMessage.setDistY(distY);
            yoloMessage.setTrust(trust);
            yoloMessage.setMappingID(typeBody.getMappingID());
        }
        return yoloMessage;
    }

    private void study(long eventID, List<SensoryNerve> sensoryNerves, ThreeChannelMatrix feature, boolean isStudy, Map<Integer, Double> E, OutBack back) throws Exception {
        for (int i = 0; i < sensoryNerves.size(); ++i) {
            Matrix p;
            switch (i) {
                case 0: {
                    p = feature.getMatrixR();
                    break;
                }
                case 1: {
                    p = feature.getMatrixG();
                    break;
                }
                default: {
                    p = feature.getMatrixB();
                }
            }
            sensoryNerves.get(i).postMatrixMessage(eventID, p, isStudy, E, back, false);
        }
    }
}

