/*
 * Decompiled with CFR 0.152.
 */
package cn.myeasyai.face;

import cn.myeasyai.face.Face;
import cn.myeasyai.face.FaceTestConfig;
import cn.myeasyai.util.SourceUtil;
import java.io.File;
import java.util.Objects;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.tools.Picture;

public class FaceFactory {
    private static volatile Face FACE;
    private static final Object LOCK;
    private static final String AVG_FACE_PATH = "avgFace.png";
    private static final String FACE_MODEL_PATH = "face.json";

    public static Face getFace() {
        if (Objects.nonNull(FACE)) {
            return FACE;
        }
        Object object = LOCK;
        synchronized (object) {
            if (Objects.nonNull(FACE)) {
                return FACE;
            }
            try {
                File file = SourceUtil.getResourceFile(AVG_FACE_PATH);
                ThreeChannelMatrix avgMatrix = Picture.getThreeMatrix((File)file, (boolean)false);
                FACE = new Face(new FaceTestConfig(), avgMatrix);
                FACE.insertModel(SourceUtil.readCreatorModel2(FACE_MODEL_PATH));
                return FACE;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize Face", e);
            }
        }
    }

    static {
        LOCK = new Object();
    }
}

