package cn.myeasyai.face;

import cn.myeasyai.util.SourceUtil;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.tools.Picture;

import java.io.File;
import java.util.Objects;

/**
 * 人脸工厂信息
 * @author lidapeng
 */
public class FaceFactory {
    private static volatile Face FACE;
    private static final Object LOCK = new Object();
    private static final String AVG_FACE_PATH = "avgFace.png";
    private static final String FACE_MODEL_PATH = "face.json";

    public static Face getFace() {
        if (Objects.nonNull(FACE)) {
            return FACE;
        }
        synchronized (LOCK) {
            if (Objects.nonNull(FACE)) {
                return FACE;
            }
            try {
                final File file = SourceUtil.getResourceFile(AVG_FACE_PATH);
                ThreeChannelMatrix avgMatrix =Picture.getThreeMatrix(file,false);
                FACE = new Face(new FaceTestConfig(), avgMatrix);
                FACE.insertModel(SourceUtil.readCreatorModel2(FACE_MODEL_PATH));
                return FACE;
            } catch (Exception e) {
                throw new RuntimeException("Failed to initialize Face", e);
            }
        }
    }

}
