package cn.myeasyai.face;

import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.i.PsoFunction;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;

public class SecondPosition implements PsoFunction {
    private final Matrix avgFace;//平均脸
    private final ThreeChannelMatrix allPic;//全图
    private final MatrixOperation matrixOperation = new MatrixOperation();
    private final Face face;
    private final int XSize;
    private final int YSize;

    public SecondPosition(Matrix avgFace, ThreeChannelMatrix allPic, Face face, int xSize, int ySize) {
        this.avgFace = avgFace;
        this.allPic = allPic;
        this.face = face;
        this.XSize = xSize;
        this.YSize = ySize;
    }

    @Override
    public double getResult(double[] doubles, int i) throws Exception {
        int x = (int) doubles[0];//x坐标
        int y = (int) doubles[1];//y坐标
        if (x >= 0 && y >= 0 && x + XSize < allPic.getX() && y + YSize < allPic.getY()) {
            ThreeChannelMatrix pic = allPic.cutChannel(x, y, XSize, YSize);
            Matrix faceMatrix = face.lookFace(pic);
            return matrixOperation.getEDistByMatrix(faceMatrix, avgFace);
        } else {
            return 100000;
        }
    }
}
