/*
 * Decompiled with CFR 0.152.
 */
package cn.myeasyai.tools;

import cn.myeasyai.face.FaceModel;
import cn.myeasyai.util.SourceUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.nerveEntity.SensoryNerve;
import org.dromara.easyai.yolo.TypeBody;
import org.dromara.easyai.yolo.TypeModel;
import org.dromara.easyai.yolo.YoloConfig;

public class Tools {
    public static TypeBody getTypeBody(TypeModel typeModel, YoloConfig yoloConfig) throws Exception {
        TypeBody typeBody = new TypeBody(yoloConfig, yoloConfig.getWindowWidth(), yoloConfig.getWindowHeight());
        typeBody.setTypeID(typeModel.getTypeID());
        typeBody.setMappingID(typeModel.getMappingID());
        typeBody.setMinWidth(typeModel.getMinWidth());
        typeBody.setMinHeight(typeModel.getMinHeight());
        typeBody.setMaxWidth(typeModel.getMaxWidth());
        typeBody.setMaxHeight(typeModel.getMaxHeight());
        typeBody.getPositonNerveManager().insertConvModel(typeModel.getPositionModel());
        return typeBody;
    }

    public static ThreeChannelMatrix fillColor(ThreeChannelMatrix picture, int heightSize, int widthSize) throws Exception {
        int myFaceHeight = picture.getX();
        int sub = myFaceHeight - heightSize;
        int fillHeight = sub / 2;
        if (fillHeight == 0) {
            fillHeight = 1;
        }
        ThreeChannelMatrix fillMatrix = null;
        if (sub > 0) {
            fillMatrix = picture.cutChannel(fillHeight, 0, heightSize, widthSize);
        } else if (sub < 0) {
            fillMatrix = Tools.getFaceMatrix(heightSize, widthSize);
            fillMatrix.fill(Math.abs(fillHeight), 0, picture);
        }
        return fillMatrix;
    }

    private static ThreeChannelMatrix getFaceMatrix(int height, int width) {
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        Matrix matrixR = new Matrix(height, width);
        Matrix matrixG = new Matrix(height, width);
        Matrix matrixB = new Matrix(height, width);
        Matrix matrixH = new Matrix(height, width);
        threeChannelMatrix.setX(height);
        threeChannelMatrix.setY(width);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        return threeChannelMatrix;
    }

    public static FaceModel readFaceModel() {
        File file = SourceUtil.getResourceFile("face.json");
        String a = Tools.readPaper(file);
        return (FaceModel)JSONObject.parseObject((String)a, FaceModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPaper(File file) {
        InputStream read = null;
        String context = null;
        try {
            read = Files.newInputStream(file.toPath(), new OpenOption[0]);
            byte[] bt = new byte[read.available()];
            read.read(bt);
            context = new String(bt, StandardCharsets.UTF_8);
            read.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }

    public static void study(long eventID, List<SensoryNerve> sensoryNerves, ThreeChannelMatrix feature, boolean isStudy, Map<Integer, Double> E, OutBack back) throws Exception {
        for (int i = 0; i < sensoryNerves.size(); ++i) {
            Matrix p;
            switch (i) {
                case 0: {
                    p = feature.getMatrixR();
                    break;
                }
                case 1: {
                    p = feature.getMatrixG();
                    break;
                }
                default: {
                    p = feature.getMatrixB();
                }
            }
            sensoryNerves.get(i).postMatrixMessage(eventID, p, isStudy, E, back, false);
        }
    }
}

